<form action="<?php echo e(route('contact.save')); ?>" method="Post" id="contactForm" class="contact-us-form" data-cues="slideInUp">
    <?php echo csrf_field(); ?>
    <div class="row justify-content-center">
        <div id="success-message" style="color: green;"></div>
            <div class="col-lg-6 col-md-12">
                <div class="form-group">
                    <input type="text" name="name" id="name" class="form-control"
                        data-error="Please enter your name" placeholder="<?php echo e(__('home.entername')); ?>">
                    <div class="print-error-msg" id="error-name" style="display:none; color: red;"></div>
                </div>
            </div>
        <div class="col-lg-6 col-md-6">
            <div class="form-group">
                <input type="email" name="email" id="email" class="form-control" \
                    data-error="Please enter your email" placeholder="<?php echo e(__('home.enteremail')); ?>">
                    <div class="print-error-msg" id="error-email" style="display:none; color: red;"></div>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="form-group">
                <input type="text" name="phone" id="phone_number"  data-error="Please enter your number"
                    class="form-control" placeholder="<?php echo e(__('home.phone')); ?>">
                    <div class="m-0 print-error-msg" id="error-phone" style="display:none; color: red;"></div>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="form-group">
                <input type="text" name="title" id="msg_subject" class="form-control"
                    data-error="Please enter your subject" placeholder="<?php echo e(__('home.subject')); ?>"
                    value="<?php echo e($jobTitle ?? ''); ?>">
                    <div class="print-error-msg" id="error-title" style="display:none; color: red;">
                    </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <div class="form-group">
                <textarea name="message" class="form-control" id="message" cols="30" rows="6"
                    data-error="Write your message" placeholder="<?php echo e(__('home.message')); ?>"></textarea>
                    <div class="print-error-msg" id="error-message" style="display:none; color: red;">
                    </div>
            </div>
        </div>

        <div class="col-lg-12 col-md-12 text-center">
            <button type="submit" class="default-btn"><?php echo e(__('home.submit-now')); ?> </button>
        </div>
    </div>
</form>
<?php $__env->startSection('script'); ?>
    <script>
        $('#contactForm').on('submit', function(e) {
            e.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);
            console.log("Form action URL:", $(this).attr('action'));
            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#contactForm')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if (messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index, message) {
                            const errorMessage = $("<div>").text(message);
                            errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php /**PATH C:\OSPanel\domains\iris\resources\views/website/web-partials/contactform.blade.php ENDPATH**/ ?>