<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_country')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.countries')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/countries')); ?>"><?php echo e(trans('home.countries')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_country')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.edit_country')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo Form::open(['method'=>'PATCH','url' => 'admin/countries/'.$country->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <!-- Row-->                                
                                <div class="row">

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                        <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($country->name_en); ?>" required>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                        <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($country->name_ar); ?>" >
                                    </div>
                        
                                </div>
                                <!-- End Row -->
                                <div class="row">
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" <?php echo e(($country->status == 1)? 'checked':''); ?> switch="success" checked/>
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/countries')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\posla\resources\views/admin/countries/editCountry.blade.php ENDPATH**/ ?>