<?php $__env->startSection('script'); ?>
    <script>
        $('#contactForm').on('submit', function(e) {
            e.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);
            console.log("The data is:", Object.fromEntries(formData.entries()));
            console.log("Form action URL:", $(this).attr('action'));
            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response.contact_message);
                    $('#contactForm')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if (messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index, message) {
                            const errorMessage = $("<div>").text(message);
                            errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\OSPanel\domains\ctc\resources\views/website/web-partials/formscript.blade.php ENDPATH**/ ?>