<!--=====BLOG AREA START=======-->
@if (isset($blogs) && count($blogs) > 0)
    <!-- Blog One Start -->
    <section class="blog-one">
        <div class="section-shape-1"
            style="background-image: url({{ asset('resources/assets/front/images/shapes/section-shape-1.png') }});">
        </div>
        <div class="container">
            @if (empty(Request::segment(2)))
                <div class="section-title text-center sec-title-animation animation-style1">
                    <h2 class="section-title__title title-animation">{{ __('home.Latest posts & articles') }}
                    </h2>
                </div>
            @endif
            <div class="row">
                <!-- Blog One Single Start -->
                @foreach ($blogs as $blog)
                    <div class="col-xl-4 col-lg-4 wow fadeInLeft" data-wow-delay="100ms">
                        <div class="blog-one__single">
                            <div class="blog-one__img">
                                <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="">
                            </div>
                            <div class="blog-one__content">
                                <div class="blog-one__content-shape-1"
                                    style="background-image: url({{ asset('resource/assets/images/front/shapes/blog-one-content-shape-1.png') }});">
                                </div>
                                <div class="blog-one__date-and-title-box">
                                    <div class="blog-one__date">
                                        <h3>{{ \Carbon\Carbon::parse($blog->date)->format('d') }}</h3>
                                        <p>{{ \Carbon\Carbon::parse($blog->date)->format('M Y') }}</p>
                                    </div>
                                    <div class="blog-one__title-box">
                                        <h3 class="blog-one__title"><a
                                                href="{{ LaravelLocalization::localizeUrl('blog/' . $blog->{'link_' . $lang}) }}">{{ $blog->{'title_' . $lang} }}</a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="blog-one__btn-box">
                                    <a href="{{ LaravelLocalization::localizeUrl('blog/' . $blog->{'link_' . $lang}) }}"
                                        class="thm-btn blog-one__btn">{{ __('home.more_details') }} <span
                                            class="icon-up-right-arrow"></span> </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                <!-- Blog One Single End -->

            </div>
            @if (empty(Request::segment(2)))
                <div class="about-two__btn-box text-center pt-5">
                    <a href="{{ LaravelLocalization::localizeUrl('blogs') }}"
                        class="thm-btn about-two__btn">{{ __('home.View More Blogs') }} <span
                            class="icon-up-right-arrow"></span>
                    </a>
                </div>
            @endif
        </div>
    </section>
    <!-- Blog One End -->

@endif
<!--=====BLOG AREA END=======-->
