<!-- Contact Two Start -->
<div class="contact__two section-padding">
    <div class="container">
        <div class="row gy-4 align-items-center">
            <div class="col-xl-6">
                <div class="contact__two-content">
                    <div class="contact__two-title">
                        <span class="subtitle-one"><?php echo e(trans('home.contact_us')); ?></span>
                        <h2><?php echo e(trans('home.book_appointment')); ?></h2>
                    </div>
                    <div class="contact__two-form">
                        <form action="<?php echo e(LaravelLocalization::LocalizeUrl('save/contact-us')); ?>" method="POST">
                            <div class="row gy-4 mb-4">
                                <div class="col-xl-6">
                                    <input type="text" placeholder="<?php echo e(trans('home.name')); ?>">
                                </div>

                                <div class="col-xl-6">
                                    <input type="email" placeholder="<?php echo e(trans('home.email')); ?>">
                                </div>

                                <div class="col-xl-6">
                                    <input type="tel" placeholder="<?php echo e(trans('home.phone')); ?>"
                                        style="text-align: right;">
                                </div>

                                <div class="col-xl-6">
                                    <div class="contect_form4">
                                        <select class="custom-select-contact" name="service_id" required>
                                            <option value="15"> <?php echo e(trans('home.Service You Need')); ?></option>
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serviceForm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($serviceForm->{'name_' . $lang}); ?>">
                                                    <?php echo e($serviceForm->{'name_' . $lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <textarea placeholder="<?php echo e(trans('home.message')); ?>"></textarea>
                            <button type="submit" class="btn-two">
                                <?php echo e(trans('home.send')); ?>

                                <i class="fas fa-chevron-left"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xl-6">
                <div class="contact__two-contact-info">
                    <?php if($setting->contact_email): ?>
                        <div class="contact__two-single-info">
                            <div class="contact__two-single-info-icon">
                                <img src="<?php echo e(url('resources/assets/front/img/icon/service-1.png')); ?>" alt="image">
                            </div>
                            <div class="contact__two-single-info-content">
                                <h4><?php echo e(trans('home.contact_email')); ?></h4>
                                <a
                                    href="mailto:<?php echo e($setting->contact_email); ?>"><span><?php echo e($setting->contact_email); ?></span></a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($phones): ?>
                        <div class="contact__two-single-info">
                            <div class="contact__two-single-info-icon">
                                <img src="<?php echo e(url('resources/assets/front/img/icon/service-2.png')); ?>" alt="image">
                            </div>
                            <div class="contact__two-single-info-content">
                                <h4><?php echo e(trans('home.phone')); ?></h4>
                                <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a
                                        href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><span><?php echo e($phone->phone); ?></span></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($dates): ?>
                        <div class="contact__two-single-info">
                            <div class="contact__two-single-info-icon">
                                <img src="<?php echo e(url('resources/assets/front/img/icon/service-3.png')); ?>" alt="image">
                            </div>
                            <div class="contact__two-single-info-content">
                                <h4><?php echo e(trans('home.dates')); ?></h4>
                                <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span><?php echo e($date->{'title_' . $lang}); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="contact__two-single-info">
                        <div class="contact__two-single-info-icon">
                            <img src="<?php echo e(url('resources/assets/front/img/icon/service-4.png')); ?>" alt="image">
                        </div>
                        <div class="contact__two-single-info-content">
                            <h4><?php echo e(trans('home.address')); ?></h4>
                            <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e($address->map_url); ?>"
                                    target="_blank"><span><?php echo e($address->{'address_' . $lang}); ?></span></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Contact Two End -->
<!-- Contact Location Start -->
<div class="location-map">
    <iframe src="<?php echo e($setting->map_url); ?>" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
</div>
<!-- Contact Location Start -->
<?php /**PATH C:\OSPanel\domains\drkorny\resources\views/website/home-partials/contact.blade.php ENDPATH**/ ?>