<title><?php echo e(trans('home.careerApplications')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.careerApplications')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.careerApplications')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.careerApplications')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th><?php echo e(trans('home.name')); ?></th>
                                    <th><?php echo e(trans('home.email')); ?></th>
                                    <th><?php echo e(trans('home.phone')); ?></th>
                                    <th><?php echo e(trans('home.position')); ?></th>
                                    
                                    
                                    <th><?php echo e(trans('home.attached_file')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $careerApplications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $careerApplication): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($careerApplication->id); ?></td>
                                        <td><?php echo e($careerApplication->name); ?></td>
                                        <td><?php echo e($careerApplication->email); ?></td>
                                        <td><?php echo e($careerApplication->phone); ?></td>
                                        <td><?php echo e($careerApplication->position); ?></td>
                                        
                                        
                                        <td><a href="<?php echo e(url('uploads/careers/pdfs/'.$careerApplication->file)); ?>" target="_blank"><span class="badge badge-success" style="color: black"><?php echo e(trans('home.download_cv')); ?></span></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\artbuild\resources\views/admin/careers/careers-applications.blade.php ENDPATH**/ ?>