<!doctype html>
<html lang="en" <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1.0" />
    <meta name="keywords" content="" />
    <meta property="og:image" content="<?php echo e(url('resources/assets/front/images/og.jpg')); ?>" />
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Favicon Icon -->
    <link rel="icon" type="image/png" href="<?php echo e(Helper::uploadedImagesPath('settings', $configration->fav_icon)); ?>" />
    <link rel="apple-touch-icon" href="<?php echo e(Helper::uploadedImagesPath('settings', $configration->fav_icon)); ?>" />
    <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo e(Helper::uploadedImagesPath('settings', $configration->fav_icon)); ?>" />
    <!-- Preconnect to improve load time -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <!-- Load the Cairo font with variable weights from 200 to 1000 -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">

    <!-- Preload the font to improve first paint performance -->
    <link rel="preload" href="https://fonts.gstatic.com/s/cairo/v16/SLXVc1nY6HkvalchcHKF.ttf" as="font"
        type="font/woff2" crossorigin="anonymous">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fontawesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slick.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('meanmenu.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('nice-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('spacing.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <!--=============== css  ===============-->
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
    <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('slick.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('waypoints.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.meanmenu.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('inview.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('tilt.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('custom.js')); ?>"></script>
    <!-- Jquery Library File -->
    <?php echo $__env->yieldContent('script'); ?>

</body>

</html>
<?php /**PATH C:\OSPanel\domains\homy\resources\views/layouts/app.blade.php ENDPATH**/ ?>