<?php if(count($albums) > 0): ?>
    <!-- Gallery  -->
    <div class="portfolio__two section-padding pt-5">
        <div class="container">
            <?php if(Request::segment(2) != 'galleryImages'): ?>
                <div class="row align-items-center justify-content-between text-right">
                    <div class="col-xl-6 col-lg-6">
                        <div class="portfolio__two-title">
                            <span class="subtitle-one"><?php echo e($configration->app_name); ?></span>
                            <h2><?php echo e(trans('home.albums')); ?><span class="highlighted-two"></span></h2>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4">
                        <div class="portfolio__one-content-right text-lg-end">
                            <a href="<?php echo e(LaravelLocalization::LocalizeUrl('galleryImages')); ?>"
                                class="btn-one"><?php echo e(trans('home.more')); ?>

                                <i class="fas fa-arrow-left"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4">
                        <div class="portfolio__two-single-item">
                            <div class="portfolio__two-single-item-img-wrapper">
                                <a href="<?php echo e(url('uploads/album_items/source/' . $album->image)); ?>"
                                    data-fancybox="gallery-<?php echo e($key); ?>" data-caption="<?php echo $album->{'text_' . $lang}; ?>">
                                    <img src="<?php echo e(url('uploads/album_items/source/' . $album->image)); ?>" alt="image">
                                    <div class="overlay">
                                        <i class="fas fa-search-plus"></i>
                                    </div>
                                </a>
                            </div>
                            <div style="display:none">
                                <?php $__currentLoopData = $album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a data-fancybox="gallery-<?php echo e($key); ?>"
                                        href="<?php echo e(url('uploads/album_items/source/' . $img->name)); ?>">
                                        <img src="<?php echo e(url('uploads/album_items/source/' . $img->name)); ?>" />
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="portfolio__two-single-item-content">
                                <div class="portfolio__two-single-item-content-left">
                                    <h3><?php echo e($album->{'name_' . $lang}); ?></h3>
                                    
                                </div>
                                
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <script>
        <?php $__currentLoopData = $album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Fancybox.bind('[data-fancybox="gallery-<?php echo e($key); ?>"]', {
                Thumbs: {
                    type: "modern"
                }
            });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </script>
    <!-- gallry  Area End -->
<?php endif; ?>
<?php /**PATH C:\OSPanel\domains\drkorny\resources\views/website/home-partials/gallery.blade.php ENDPATH**/ ?>