<?php
    $blogsTitles = $titles->filter(fn($title) => $title->type === 'blogs');
?>

<?php if(count($blogs) > 0): ?>
    <!--===============Blogs==============-->
    <div class="our-blog">
        <div class="container">
            <div class="row section-row align-items-center">
                <div class="col-lg-6">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h3 class="wow fadeInUp"><?php echo e(trans('home.blogs')); ?></h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque"><span><?php echo e($title->{'title_' . $lang}); ?></span>
                            <?php echo e($title->{'title1_' . $lang}); ?></h2>
                    </div>
                    <!-- Section Title End -->
                </div>

                <div class="col-lg-6">
                    <!-- Section Title Content Start -->
                    <div class="section-title-content">
                        <p class="wow fadeInUp" data-wow-delay="0.2s"><?php echo $title->{'text_' . $lang}; ?></p>
                    </div>
                    <!-- Section Title Content End -->
                </div>
            </div>

            <div class="row">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6">
                        <!-- Post Item Start -->
                        <div class="post-item wow fadeInUp">
                            <div class="post-featured-image">
                                <figure>
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang})); ?>"
                                        class="image-anime" data-cursor-text="View">
                                        <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $blog->image)); ?>"
                                            alt="image">
                                    </a>
                                </figure>
                            </div>
                            <div class="post-item-body">
                                <div class="post-item-content">
                                    <h3><a
                                            href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang})); ?>"><?php echo e($blog->{'title_' . $lang}); ?></a>
                                    </h3>
                                </div>
                                <div class="post-item-btn">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang})); ?>"
                                        class="post-btn"><?php echo e(trans('home.blogdetials')); ?></a>
                                </div>
                            </div>
                        </div>
                        <!-- Post Item End -->
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-12">
                    <!-- Our Blog Footer Start -->
                    <div class="our-blog-footer wow fadeInUp" data-wow-delay="0.6s">
                        <a href="<?php echo e(LaravelLocalization::LocalizeUrl('blogs')); ?>"
                            class="btn-default"><?php echo e(trans('home.all_blogs')); ?></a>
                    </div>
                    <!-- Our Blog Footer End -->
                </div>
            </div>
        </div>
    </div>
    <!--===============Blogs==============-->
<?php endif; ?>
<?php /**PATH C:\OSPanel\domains\artbuild\resources\views/website/home-partials/blogs.blade.php ENDPATH**/ ?>