<title><?php echo e(trans('home.galleryVideos')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.galleryVideos')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.galleryVideos')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/gallery-videos/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>


        <!-- Row-->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table" id="datatable">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll"/></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.video')); ?></th>
                                <th><?php echo e(trans('home.order')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th><?php echo e(__('home.delete')); ?>

                                    <div class="d-block">
                                        <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light" ><?php echo e(__('home.delete')); ?></a>
                                    <div>                                 
                                </th>
                            </tr>
                        </thead>
                        <tbody class="sortable">
                            <?php $__currentLoopData = $galleryVideos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $galleryVideo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($galleryVideo->id); ?>" data-id="<?php echo e($galleryVideo->id); ?>"  class="image">
                                    <td> <input type="checkbox" name="checkbox"  class="tableChecked form-check-input" value="<?php echo e($galleryVideo->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('gallery-videos.edit', $galleryVideo->id)); ?>"><?php echo e($galleryVideo->id); ?></a></td>
                                    <td>
                                        <a href="<?php echo e(route('gallery-videos.edit', $galleryVideo->id)); ?>">
                                            <iframe width="200" height="150"
                                                src="<?php echo e($galleryVideo->youtube_link); ?>">
                                            </iframe>
                                        </a>
                                    </td>
                                    <td class="order"><?php echo e($galleryVideo->order); ?></td>
                                    <td> 
                                        <input class="btn_active" data-id="<?php echo e($galleryVideo->id); ?>" type="checkbox" id="switch-<?php echo e($galleryVideo->id); ?>" switch="success" <?php echo e($galleryVideo->status == 1?'checked':''); ?> />
                                        <label for="switch-<?php echo e($galleryVideo->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-info waves-effect waves-light " 
                                            href="<?php echo e(route('gallery-videos.edit',$galleryVideo->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                            data-id="<?php echo e($galleryVideo->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
				</div>
			</div>
		</div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        /////// make table row sortable ////
        $(document).ready(function () {
            var $videos = $('.sortable');
            $videos.sortable({
                connectWith: '.sortable',
                items: 'tr.image',
                stop: (event, ui) => {
                    sendReordervideosRequest($(ui.item).parent());
    
                    if ($(event.target).data('id') != $(ui.item).parent().data('id')) {
                        if ($(event.target).find('tr.image').length) {
                            sendReordervideosRequest($(event.target));
                        } else {
                            $(event.target).find('.empty-message').show();
                        }
                    }
                }
            });
            $('table, .sortable').disableSelection();
        });
        
        ////// send reorder request //////////////
        function sendReordervideosRequest($image) {
            var items = $image.sortable('toArray', {attribute: 'data-id'});
            var ids = $.grep(items, (item) => item !== "");
            var _token = $('meta[name="csrf-token"]').attr('content');
            
            if ($image.find('tr.image').length) {
                $image.find('.empty-message').hide();
            }

            $.post('<?php echo e(url('admin/gallery-videos/reorder')); ?>', {
                _token,
                ids,
            })
            .done(function (response) {
                $image.children('tr.image').each(function (index, image) {
                    $(image).children('.order').text(response.positions[$(image).data('id')])
                });
            })
            .fail(function (response) {
                alert('Error occured while sending reorder request');
                location.reload();
            });
        }

    </script>
<?php $__env->stopSection(); ?>    

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\drkorny\resources\views/admin/galleryVideos/galleryVideos.blade.php ENDPATH**/ ?>