<title><?php echo e(trans('home.edit')); ?></title>
<?php $__env->startSection('style'); ?>
<style>
    img {
        display:block !important;
    }
    .dz-hidden-input{
        position: absolute !important;
        top: 0px !important;
        left: 250px !important;
    }

</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.albums')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/albums')); ?>"><?php echo e(trans('home.albums')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(trans('home.edit')); ?></h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <?php echo Form::open(['method'=>'PATCH','url' => 'admin/albums/'.$album->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                    <div class="row">

                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                            <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($album->name_en); ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                            <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($album->name_ar); ?>" >
                                        </div>
                                        
                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.text_en')); ?></label>
                                            <input class="form-control" name="text_en" type="text" placeholder="<?php echo e(trans('home.text_en')); ?>"  value="<?php echo e($album->text_en); ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.text_ar')); ?></label>
                                            <input class="form-control" name="text_ar" type="text" placeholder="<?php echo e(trans('home.text_ar')); ?>" value="<?php echo e($album->text_ar); ?>" >
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
                                        <?php if($album->image): ?>
                                            <div class="form-group  col-md-2 m-2 mt-3">
                                                <img src="<?php echo e(url('uploads\album_items\source')); ?>\<?php echo e($album->image); ?>" width="200" height="150">
                                            </div>
                                        <?php else: ?>
                                            <div class="form-group  col-md-3 mt-3">
                                                <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                            </div>
                                        <?php endif; ?>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <label for="images"><?php echo e(trans('home.images')); ?></label>
                                                <div class="dropzone col-md-12 upload_images">
                                            </div>
                                        </div>
                                        <?php if(isset($album->images)): ?>
                                            <?php $__currentLoopData = $album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-group col-md-4 mt-2">
                                                <img src="<?php echo e(url('uploads/album_items/source/'.$image->name)); ?>"  width="150px" height="150px"/>
                                                <a href='#' data-image='<?php echo e($image->id); ?>' class='btn btn-danger m-2 delete_img_btn px-5' ><?php echo e(trans('home.delete')); ?></a>
                                            </div>
                                        
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <div class="d-flex justify-content-end">
                                                    <a href='#' data-id="<?php echo e($album->id); ?>" class='delete_all_img btn btn-danger mt-2 col-2' ><?php echo e(trans('home.delete_all')); ?></a>
                                                </div>
                                        <?php endif; ?>

                                        
                                    </div>
                                    <div class="row mt-3">
                                        <div class="form-group col-4">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e($album->status?'checked':''); ?>/>
                                                <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                        <a href="<?php echo e(url('/admin/albums')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                    </div>


                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>
    
    <script type="text/javascript">

        var token = "<?php echo e(csrf_token()); ?>";
        //Dropzone.autoDiscover = true;
        Dropzone.autoDiscover = false;

        $("div.upload_images").dropzone({
            
            addRemoveLinks: true,
            acceptedFiles: ".jpeg,.jpg,.png,.gif,.webp",
            url: "<?php echo e(URL::to('admin/album-images/uploadImages')); ?>",

            init: function() {
                this.on("sending", function(file, xhr, formData) {
                });
            },
            
            params: {
                _token: token,
                type: 'gallery_image',
            },

            removedfile: function(file) {

                var fileName = file.name; 
                $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
                    $.ajax({
                    type: 'POST',
                    url: "<?php echo e(URL::to('admin/album-images/removeUploadImages')); ?>",
                    data: {type:'gallery_image',name: fileName,request: 'delete'},
                    sucess: function(data){
                        console.log('success: ' + data);
                    }
                });
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }

        });
        
    
        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 10, // MB
            accept: function(file, done) {

            },
        };
        
        $('.delete_img_btn').on('click',function(){
            var image = $(this).data('image');
            var albumId=<?php echo e($album->id); ?>;
            var btn = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:" <?php echo e(url('admin/album-images/deleteImage')); ?>",
                method:'POST',
                data:{image:image , albumId:albumId },
                success:function(data)
                {
                    location.href = "<?php echo e(route('albums.edit',$album->id)); ?>";
                }
            });
        });
        
    </script>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\shahin\resources\views/admin/albums/edit.blade.php ENDPATH**/ ?>