@if ($services->isNotEmpty())
@php
$serviceTitle = $titles->where('type' , 'services');
@endphp
<!--==========================Services==========================-->
<div class="full-row bg-light mt-50">
    <div class="container">
        <div class="row row-cols-lg-3 row-cols-md-2 row-cols-1 gy-5">
            @foreach($services as $service)
            <div class="col">
                <div class="entry-wrapper d-flex flex-column align-items-start justify-content-start transition-all count wow animate__animated animate__fadeInUp" data-wow-delay="200ms" data-wow-duration="900ms">
                    <div class="entry-thumbnail-wrapper">
                        <div class="post-thumbnail service-img overflow-hidden hover-img-zoom">
                            <img src="{{ Helper::uploadedImagesPath('services', $service->img) }}" alt="Image not found !">
                        </div>
                    </div>
                    <div class="entry-content-wrapper pt-20">
                        <div class="entry-header">
                            <h3 class="entry-title mb-3"><a href="{{ LaravelLocalization::LocalizeUrl('service/' . $service->{'link_' . $lang}) }}" class="text-secondary hover-text-primary">{{ $service->{'name_' . $lang} }}</a></h3>
                        </div>
                        <div class="entry-content">
                            <p>{!! $service->{'text1_' .$lang} !!}</p>
                        </div>
                        <div class="entry-footer">
                            <div class="mt-3"><a href="{{ LaravelLocalization::LocalizeUrl('service/' . $service->{'link_' . $lang}) }}" class="btn-link text-primary btn-hover-downline-1 fw-400">{{ trans('home.more') }}</a></div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

    </div>
</div>
<!--==========================Services==========================-->
@endif