@if($blogs->isNotEmpty())
<!--===============Blogs==============-->
@php
$blogsTitles = $titles->where('type' , 'blogs')
@endphp
<div class="full-row bg-light pt-40">
    <div class="container">
        <div class="row row-cols-lg-3 row-cols-md-2 row-cols-1 gy-5 blog-style-1 entry-meta-divider-line transition-all">
            @foreach($blogs as $blog)
            <div class="col">
                <article class="entry-wrapper">
                    <div class="entry-thumbnail-wrapper">
                        <div class="post-thumbnail blog-img overflow-hidden overlay-secondary">
                            <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}"><img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="Image not found !"></a>
                        </div>
                    </div>
                    <div class="entry-content-wrapper pt-3">
                        <div class="entry-header">
                            <div class="entry-meta text-uppercase fs-13">
                                <span class="posted-date"><a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}" class="text-light hover-text-primary"></a></span>
                            </div>
                            <h5 class="entry-title mb-3 ordinary-font fw-500"><a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}" class="text-dark hover-text-primary">{{ $blog->{'title_' . $lang} }}</a></h5>
                        </div>
                    </div>
                </article>
            </div>
            @endforeach
        </div>
    </div>
</div>
<!--===============Blogs==============-->
@endif