@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_head_headers')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.head_headers')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/titles')}}">{{trans('home.head_headers')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.add_head_headers')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{trans('home.add_head_headers')}}</h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'titles.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">


                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.title_en')}}</label>
                                            <input class="form-control" name="title_en" type="text" placeholder="{{trans('home.title_en')}}" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.title_ar')}}</label>
                                            <input class="form-control" name="title_ar" type="text" placeholder="{{trans('home.title_ar')}}" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.title_en')}}</label>
                                            <input class="form-control" name="title1_en" type="text" placeholder="{{trans('home.title_en')}}">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.title_ar')}}</label>
                                            <input class="form-control" name="title1_ar" type="text" placeholder="{{trans('home.title_ar')}}">
                                        </div>
                                        <div class="col-md-8 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>

                                        <div class="col-md-2 mb-3">
                                            <label >{{trans('home.alt_img')}}</label>
                                            <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}" />
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <label for="order">{{trans('home.order')}}</label>
                                            <input type="number" min="0"  class="form-control" placeholder="{{trans('home.order')}}" name="order">
                                        </div>
                                        <div class="form-group col-md-6 ">
                                            <label for="text_en">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic" name="text_en"  placeholder="{{trans('home.text_en')}}"></textarea>
                                    </div>
                                        <div class="form-group col-md-6 ">
                                            <label for="text_ar">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic" name="text_ar"  placeholder="{{trans('home.text_ar')}}"></textarea>
                                    </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.number')}}</label>
                                            <input class="form-control" name="number" type="number" placeholder="{{trans('home.number')}}">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.link')}}</label>
                                            <input class="form-control" name="link" type="link" placeholder="{{trans('home.link')}}">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label for="type">{{trans('home.parent')}}</label>
                                            <select class="form-control"  data-trigger name="type" required>
                                                <option value="about">{{trans('home.about-us')}}</option>
                                                <option value="aboutStruc">{{trans('home.aboutStruc')}}</option>
                                                <option value="services">{{trans('home.services')}}</option>
                                                <option value="gallery">{{trans('home.gallery')}}</option>
                                                <option value="contact">{{trans('home.contact-us')}}</option>
                                                <option value="blogs">{{trans('home.blogs')}}</option>
                                                <option value="reviews">{{trans('home.reviews')}}</option>
                                                <option value="whyus">{{trans('home.whyus')}}</option>
                                                <option value="teams">{{trans('home.teams')}}</option>
                                                <option value="skills">{{trans('home.skills')}}</option>
                                                <option value="vedios">{{trans('home.vedios')}}</option>
                                                <option value="projects">{{trans('home.projects')}}</option>
                                                <option value="brand">{{trans('home.brands')}}</option>
                                                <option value="testimonial">{{trans('home.testimonial')}}</option>
                                                <option value="footer">{{trans('home.footer')}}</option>
                                                <option value="slider">{{trans('home.slider')}}</option>
                                                <option value="careers">{{trans('home.careers')}}</option>
                                                <option value="date">{{trans('home.date')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" checked />
                                            <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                            <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/titles')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection

