@extends('layouts.admin')
<title>{{trans('home.add')}}</title>
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.albums')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/albums')}}">{{trans('home.albums')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.add_blog_item')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'albums.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">

                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.name_en')}}</label>
                                            <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.name_ar')}}</label>
                                            <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.text_en')}}</label>
                                            <input class="form-control" name="text_en" type="text" placeholder="{{trans('home.text_en')}}">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class="">{{trans('home.text_ar')}}</label>
                                            <input class="form-control" name="text_ar" type="text" placeholder="{{trans('home.text_ar')}}">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="helperText">{{trans('home.type')}}</label>
                                            <select class="form-control" data-trigger name="type" required>
                                                    <option value="images">Images</option>
                                                    <option value="video">Video</option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row mt-3">
                                        <div class="form-group col-4">

                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" checked/>
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/albums')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection

