<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    public function images(){
        return ServiceImage::where('service_id',$this->id)->get();
    }

    public function writer()
    {
        return $this->belongsTo(Writer::class, 'writer_id');
    }

    public function childs()
    {
        return $this->hasMany(Service::class, 'parent_id')->where('status', 1)->orderBy('order', 'asc');
    }

    public function projects()
    {
        return $this->hasMany(Project::class, 'service_id')->where('status', 1);
    }
}
