<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $table = 'projects';

	public function images(){
	    return ProjectImage::where('project_id',$this->id)->get();
	}

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    public function attributes()
    {
        return $this->hasMany(ProjectAttribute::class, 'project_id');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }
}

