<?php

namespace App\Http\Controllers;

use App\Models\Address;
use App\Models\IntroSlider;
use App\Models\Testimonial;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\HomeSlider;
use App\Models\Category;
use App\Models\HomeImage;
use DB;
use App\Models\MenuItem;
use Auth;
use App\Models\Service;
use App\Models\Project;
use App\Models\Page;
use App\Models\AboutStruc;
use App\Models\About;
use App\Models\ContactUs;
use App\Models\Setting;
use App\Models\Title;
use Mail;
use App\Models\BlogCategory;
use App\Models\Team;
use App\Models\BlogItem;
use App\Models\GalleryImage;
use App\Models\BeforeAfter;
use App\Models\GalleryVideo;
use App\Models\SeoAssistant;
use App\Models\Configration;
use Melbahja\Seo\Schema;
use Melbahja\Seo\Schema\Thing;
use Melbahja\Seo\MetaTags;
use App\Models\Faq;
use App\Models\Comment;
use App\Models\Writer;
use App\Models\Brand;
use App\Models\Partner;
use App\Traits\SeoTrait;
use App\Support\Collection;
use App\Models\Career;
use App\Models\Date;
use App\Models\CareerApplication;
use App\Models\TrainingApplication;
use \Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class WebsiteController extends Controller
{
    use SeoTrait;
    public function checkUrl($slug)
    {
        $checkMenu = MenuItem::where('type', $slug)->first();
        // $checkBlog = BlogItem::where('link_en', $slug)->orWhere('link_ar', $slug)->first();
        // $checkService = Service::where('link_en',$slug)->orWhere('link_ar',$slug)->first();
        // $checkProject = Project::where('link_en', $slug)->orWhere('link_ar', $slug)->first();

        if ($checkMenu) {
            return $this->menus($checkMenu->type);
        } else {
            abort('404');
        }
    }

    //////// function retun dynamic menu//////////
    public function menus($menu)
    {
        $menu = MenuItem::where('type', $menu)->first();
        $lang = \LaravelLocalization::getCurrentLocale();

        if (!$menu) {
            abort(404);
        } elseif ($menu->type == 'home') {
            return $this->home();
        } elseif ($menu->type == 'about-us') {
            return $this->aboutUs();
        } elseif ($menu->type == 'contact-us') {
            return $this->contactUs();
        } elseif ($menu->type == 'projects') {
            return $this->getProjects();
        } elseif ($menu->type == 'services') {
            return $this->getservices();
        } elseif ($menu->type == 'galleryImages') {
            return $this->getGalleryImages();
        } elseif ($menu->type == 'galleryVideos') {
            return $this->getGalleryVideos();
        } elseif ($menu->type == 'blogs') {
            return $this->getBlogs();
        } elseif ($menu->type == 'careers') {
            return $this->getCareersPage();
        } elseif ($menu->type == 'training') {
            return $this->applyTrainingPage();
        } elseif ($menu->type == 'developers') {
            return $this->developersPage();
        }


    }

    ////////////// function returnindex page///////////
    public function home()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $intro_sliders = IntroSlider::where('lang', $lang)->where('status', 1)->get();
        $sliders = HomeSlider::where('lang', $lang)->where('status', 1)->orderBy('order')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->take(10)->get();
        $blogs = BlogItem::where('status', 1)->where('home', 1)->take(3)->get();
        $categories = Category::where('status', 1)->where('home', 1)->get();
        $about = About::first();
        $brands = Brand::where('status', 1)->orderBy('order', 'ASC')->get();
        $partners = Partner::where('status', 1)->orderBy('order', 'ASC')->get();
        $testimonials = Testimonial::where('status', 1)->where('lang', $lang)->get();
        $teams = Team::where('lang', $lang)->where('status', 1)->get();
        $projects = Project::where('status', 1)->where('recommended', 1)->orderBy('order', 'ASC')->get();
        //dd($projects);
        $galleryImages = GalleryImage::where('status', 1)->orderBy('order', 'asc')->take(5)->get();
        $careers = Career::where('status', 1)->orderBy('order', 'ASC')->get();
        $secType = new Career;
        $titles = Title::where('status', 1)->orderBy('order', 'ASC')->get();
        $secType = new Title;
        $homeImages = HomeImage::get();
        $videos = GalleryVideo::where('status', 1)->orderBy('order', 'asc')->get();
        ////// seo script//////
        list($schema, $metatags) = $this->homePageSeo();

        return view('website.home', compact('secType', 'homeImages', 'careers', 'teams', 'intro_sliders', 'sliders', 'galleryImages', 'services', 'about', 'testimonials', 'projects', 'blogs', 'schema', 'metatags', 'categories', 'brands' , 'videos' , 'partners'));
    }

    public function getWriter($id)
    {
        $writer = Writer::find($id);
        $blogss = BlogItem::where('status', 1)->where('writer_id', $id)->get();
        $lang = \LaravelLocalization::getCurrentLocale();
        $about = About::first();
        $configration = Configration::where('lang', $lang)->first();
        $setting = Setting::first();
        $title = Title::first();
        $seo = SeoAssistant::first();
        $schema1 = new Thing('LocalBusiness', [
            'name' => $configration->app_name,
            'url' => LaravelLocalization::localizeUrl('/'),
            'image' => url("uploads/settings/source/$configration->app_logo"),
            'telephone' => $setting->mobile,
            'address' => $configration->address1,
        ]);


        $schema2 = new Thing('Organization', [
            'url' => LaravelLocalization::localizeUrl('/'),
            'logo' => url("uploads/settings/source/$configration->app_logo"),
            'contactPoint' => new Thing('ContactPoint', [
                'telephone' => $setting->mobile,
                'contactType' => 'customer service'
            ]),
        ]);

        $schema = new Schema(
            $schema1,
            $schema2
        );

        $metatags = new MetaTags();
        $metatags
            ->title(($seo->home_meta_title) ? $seo->home_meta_title : $configration->app_name)
            ->meta('title', ($seo->home_meta_title) ? $seo->home_meta_title : $configration->app_name)
            ->description(($seo->home_meta_desc) ? $seo->home_meta_desc : strip_tags($configration->about_app))
            ->meta('author', $configration->app_name)
            ->image(url("uploads/settings/source/$configration->app_logo"))
            ->mobile(LaravelLocalization::localizeUrl('/'))
            ->canonical(LaravelLocalization::localizeUrl('/'))
            ->shortlink(LaravelLocalization::localizeUrl('/'))
            ->meta('robots', ($seo->home_meta_robots) ? 'index' : 'noindex');


        return view('website.writer_details', compact('writer', 'metatags', 'blogss', 'schema', 'setting', 'lang', 'seo'));
    }

    ////////////FUNCTION RETURN VIEW ABOUT US//////
    public function aboutUs()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $about = About::first();
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $aboutStrucs = AboutStruc::where('lang', $lang)->where('status', 1)->orderBy('order' , 'ASC')->get();
        $statments = Career::where('status', 1)->where('type', 'statistics')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->get();
        $testimonials = Testimonial::where('status', 1)->where('lang', $lang)->get();
        $teams = Team::where('lang', $lang)->where('status', 1)->get();
        $sliderCount = 1;
        $slidercount = 1;
        $careers = Career::where('status', 1)->orderBy('order', 'ASC')->get();
        ////// seo script//////
        list($schema, $metatags) = $this->aboutUsPageSeo();
        return view('website.about-us', compact('careers', 'lang', 'about', 'statments', 'aboutStrucs', 'metatags', 'schema', 'services', 'blogCategories', 'teams', 'testimonials', 'sliderCount', 'slidercount'));
    }

    ////////////FUNCTION RETURN VIEW CONTACT US//////
    public function contactUs()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $addresses = Address::where('status', 1)->get();
        $contact_messagges = Page::where('status', 1)->orderBy('id')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->get();
        ////// seo script//////
        list($schema, $metatags) = $this->contactUsPageSeo();
        return view('website.contact-us', compact('lang', 'addresses', 'schema', 'contact_messagges', 'metatags', 'blogCategories', 'services'));
    }
    public function appointment()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $addresses = Address::where('status', 1)->get();
        $contact_messagges = Page::where('status', 1)->orderBy('id')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->get();
        ////// seo script//////
        list($schema, $metatags) = $this->contactUsPageSeo();
        return view('website.appointment', compact('lang', 'addresses', 'schema', 'contact_messagges', 'metatags', 'blogCategories', 'services'));
    }

    ////////////// function saveContact //////////
    public function saveContactUs(Request $request)
    {
        $request->validate([
            'name' => 'required|max:150',
            'email' => 'nullable|email',
            'message' => 'nullable',
            'phone' => 'required|regex:/^[\+]?[0-9]{9,15}$/',
            'service' => 'nullable|string|max:150',
            'project_id' => 'nullable|exists:projects,id', 
            'project_name' => 'nullable|string|max:255',   
            'service_id' => 'nullable|exists:services,id',  
            'service_name' => 'nullable|string|max:255',    
        ]);
        $contact = new ContactUs();
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->phone = $request->phone;
        $contact->message = $request->message;
        $contact->service = $request->service;
        
        $contact->project_id = $request->project_id;
        $contact->project_name = $request->project_name;
        $contact->service_id = $request->service_id;
        $contact->service_name = $request->service_name;

        $contact->save();
        
        $data = array(
            'contact' => $contact,
            'project_name' => $request->project_name,
            'project_id' => $request->project_id,
            'service_name' => $request->service_name,
            'service_id' => $request->service_id
        );
        
        $setting = Setting::first();
        Mail::send('emails/contact_email', $data, function ($msg) use ($setting, $request) {
            $subject = 'DrHussam - ';
            if ($request->project_name && $request->service_name) {
                $subject .= 'Project: ' . $request->project_name . ' | Service: ' . $request->service_name;
            } elseif ($request->project_name) {
                $subject .= 'Project: ' . $request->project_name;
            } elseif ($request->service_name) {
                $subject .= 'Service: ' . $request->service_name;
            } else {
                $subject .= 'New Contact';
            }
            
            
            $msg->to([$setting->contact_email], 'Booking Appointment')->subject($subject);
            $msg->cc(['ahmed.essam.be@gmail.com']);
            $msg->from(config('mail.from.address'), config('mail.from.name'));
        });
    
        return back()->with(['contact_message' => trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);
    }

    ////////// FUNCTION RETURN PAGE INFORMATION /////////
    public function getPage($link)
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $page = Page::where('link_en', $link)->orwhere('link_ar', $link)->first();
        return view('website.page', compact('lang', 'page'));
    }

    /////////////////////FUNCTION RETURN VIEW BLOGS ///////////
    public function getBlogs($link = null)
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        if ($link) {
            $blogCategory = BlogCategory::where('link_en', $link)->orwhere('link_ar', $link)->first();
            $blogs = BlogItem::where('blogcategory_id', $blogCategory->id)->where('status', 1)->get();
            $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
            $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->take(6)->get();
            ////// seo script//////
            list($metatags) = $this->CategoryBlogsPageSeo($link);
            return view('website.category-blogs', compact('lang', 'blogCategory', 'blogs', 'metatags', 'services', 'blogCategories'));
        } else {
            $blogs = BlogItem::where('status', 1)->get();
            ////// seo script//////
            list($metatags) = $this->blogsPageSeo();
            return view('website.blogs', compact('lang', 'blogs', 'metatags'));
        }
    }

    /////////////////////FUNCTION RETURN VIEW BLOG ///////////
    public function getBlogPage($link)
    {
        $blog = BlogItem::where('link_en', $link)->orwhere('link_ar', $link)->first();
        if (!$blog) {
            abort(404);
        }
        $blog->update(['n_seen' => $blog->n_seen + 1]);
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->take(6)->get();
        $faqs = Faq::where('type', 'blog_item')->where('blog_item_id', $blog->id)->get();
        $blogs = BlogItem::where('status', 1)->take(6)->get();
        $comments = Comment::where('type', 'blog')->where('type_id', $blog->id)->where('admin_approve', 1)->get();
        $nextBlog = BlogItem::where('id', '>', $blog->id)->where('status', 1)->orderBy('id')->first();
        $previousBlog = BlogItem::where('id', '<', $blog->id)->where('status', 1)->orderByDesc('id')->first();

        ////// seo script//////
        list($schema, $metatags) = $this->blogSeo($link);

        return view('website.blog_details', compact('blog', 'schema', 'metatags', 'faqs', 'comments', 'blogs', 'services', 'blogCategories', 'nextBlog', 'previousBlog'));
    }
    /////////////////////FUNCTION RETURN VIEW Brad ///////////
    public function getBrandPage($link)
    {
        $brand = Brand::where('link_en', $link)->orwhere('link_ar', $link)->first();
        $products = Project::where('status', 1)->where('brand_id', $brand->id)->get();
        $brands = Brand::where('status', 1)->take(6)->get();
        ////// seo script//////
        list($schema, $metatags) = $this->brandSeo($link);
        return view('website.brandPage', compact('brand', 'products', 'schema', 'metatags', 'brands'));
    }

    ////////// function return list of published Brands/////
    public function getBrands()
    {
        $brands = Brand::where('status', 1)->orderBy('order', 'ASC')->get();
        ////// seo script//////
        list($metatags) = $this->brandsPageSeo();
        return view('website.brands', compact('brands', 'metatags'));
    }
    public function getPartners()
    {
        $partners = Partner::where('status', 1)->orderBy('order', 'ASC')->get();
        ////// seo script//////
        list($metatags) = $this->partnersPageSeo();
        return view('website.partners', compact('partners', 'metatags'));
    }
    ////////// function return list of published products/////
    public function getProjects()
    {
        // $projects =Project::where('status',1)->get();
        $categories = Category::where('status', 1)->get();
        $projects = Project::where('status', 1)->orderBy('order', 'ASC')->get();
        $services = Service::where('status', 1)->orderBy('order', 'ASC')->get();

        $condition = 'medium';

        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.projects', compact('categories', 'metatags', 'projects', 'condition' , 'services'));
        // return view('website.products',compact('projects','metatags'));
    }

    ////////// function return project Details /////
    public function getProductDetails($link)
    {
        $project = Project::where('link_en', $link)->orwhere('link_ar', $link)->first();
        $category_id = request()->get('category_id');
        $nextProject = Project::where('id', '>', $project->id)->where('status', 1)->orderBy('id')->first();
        $previousProject = Project::where('id', '<', $project->id)->where('status', 1)->orderByDesc('id')->first();

        if (!$nextProject) {
            $nextProject = Project::where('status', 1)->orderBy('id')->first();
        }
        if (!$previousProject) {
            $previousProject = Project::where('status', 1)->orderBy('id')->first();
        }
        if ($project) {
            $new_Projects = Project::where('updated_at', '>', Carbon::now()->subDays(30))->where('category_id', $project->category_id)->orderBy('id')->take(6)->get();

            list($schema, $metatags) = $this->projectPageSeo($link);
            return view('website.project-details', compact('project', 'new_Projects', 'schema', 'metatags', 'nextProject' , 'previousProject' , 'category_id'));
        } else {
            abort('404');
        }
    }

    ////////// function return list of published services/////
    public function getservices()
    {
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->get();
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $careers = Career::where('status', 1)->orderBy('order', 'ASC')->get();
        $about = About::first();
        ////// seo script//////
        list($metatags) = $this->servicesPageSeo();
        return view('website.services', compact('services', 'metatags', 'blogCategories', 'about', 'careers'));
    }
    public function getServiceDetails($link)
    {
        $service = Service::where('link_en', $link)->orwhere('link_ar', $link)->first();
        $projects = Project::where('status', 1)->where('service_id', $service->id)->get();

        if (!$service) {
            abort(404);
        }
        $projects = Project::where('service_id', $service->id)->where('status', 1)->get();
        $subServices = Service::where('parent_id', $service->id)->where('status', 1)->get();
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $about = About::first();
        if (count($subServices) > 0) {
            $faqs = Faq::where('type', 'service')->where('service_id', $service->id)->get();
            $services = $subServices;
            ////// seo script//////
            list($schema, $metatags) = $this->serviceSeo($link);
            return view('website.sub-services', compact('service', 'services', 'faqs', 'metatags', 'blogCategories', 'about', 'projects'));
        }

        if ($service) {
            $faqs = Faq::where('type', 'service')->where('service_id', $service->id)->get();
            $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->get();
            $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
            $projects = Project::where('status', 1)->get();
            $nextService = Service::where('id', '>', $service->id)->where('status', 1)->orderBy('id')->first();
            $previousService = Service::where('id', '<', $service->id)->where('status', 1)->orderByDesc('id')->first();

            $about = About::first();
            ////// seo script//////
            list($schema, $metatags) = $this->serviceSeo($link);
            return view('website.service-details', compact('service', 'services', 'metatags', 'schema', 'faqs', 'blogCategories', 'about', 'projects'));
        } else {
            abort('404');
        }
    }

    public function getGalleryImages()
    {
        $galleryImages = GalleryImage::where('status', 1)->orderBy('order', 'asc')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->take(6)->get();
        ////// seo script//////
        list($schema, $metatags) = $this->galleryImagesPageSeo();
        return view('website.gallery-images', compact('metatags', 'schema', 'services', 'galleryImages'));
    }
    public function getBeforeAfters()
    {
        $beforeAfters = BeforeAfter::where('status', 1)->orderBy('order', 'asc')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->take(6)->get();
        ////// seo script//////
        list($schema, $metatags) = $this->beforeAftersPageSeo();
        return view('website.beforeAfters', compact('metatags', 'schema', 'services', 'beforeAfters'));
    }

    public function getGalleryVideos()
    {
        $videos = GalleryVideo::where('status', 1)->orderBy('order', 'asc')->get();
        $blogCategories = BlogCategory::orderBy('id', 'desc')->get();
        $services = Service::where('parent_id', 0)->where('status', 1)->orderBy('order')->orderBy('name_ar')->take(6)->get();
        ////// seo script//////
        list($schema, $metatags) = $this->galleryVideosPageSeo();
        return view('website.gallery-videos', compact('videos', 'metatags', 'schema', 'blogCategories', 'services'));
    }

    public function saveComment(Request $request)
    {
        $add = new Comment();
        $add->name = $request->name;
        $add->email = $request->email;
        $add->comment = $request->comment;
        $add->type = $request->type;
        $add->type_id = $request->type_id;
        $add->save();
        return back()->with(['success' => trans('home.Thank you for your Comment , your commnet under review')]);

    }




    public function getDeveloperProjects($link)
    {
        $developer = Brand::where('link_en', $link)->orwhere('link_ar', $link)->first();

        $projects = Project::where('brand_id', $developer->id)->where('status', 1)->get();
        $projects = (new Collection($projects))->paginate(18);
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.developer-project', compact('projects', 'metatags', 'developer'));
    }


    public function projectsSearchResults(Request $request)
    {

        $projects = Project::where('status', 1)->whereBetween('price', [intval($request->from) - 1, intval($request->to) + 1])->get();

        if ($request->project_name) {
            $projects = Project::where('status', 1)->whereBetween('price', [intval($request->from) - 1, intval($request->to) + 1]);
            $projects = $projects->where('name_en', 'like', '%' . $request->project_name . '%')->orwhere('name_ar', 'like', '%' . $request->project_name . '%')->get();
        }

        if ($request->region_id) {
            $projects = Project::where('status', 1)->whereBetween('price', [intval($request->from) - 1, intval($request->to) + 1]);
            $projects = $projects->where('name_en', $request->region_id)->get();
        }

        if ($request->developer_id) {
            $projects = Project::where('status', 1)->whereBetween('price', [intval($request->from) - 1, intval($request->to) + 1]);
            $projects = $projects->where('brand_id', $request->developer_id)->get();
        }

        if ($request->project_area) {
            $projects = Project::where('status', 1)->whereBetween('price', [intval($request->from) - 1, intval($request->to) + 1]);
            $projects = $projects->where('project_area', $request->project_area)->get();
        }
        $projects = (new Collection($projects))->paginate(18);

        return view('website.search-results', compact('projects'));
    }

    public function getRecommendedProjects()
    {
        $projects = Project::where('status', 1)->where('recommended', 1)->get();
        $recommendedProjects = (new Collection($projects))->paginate(18);
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.all-recommended-projects', compact('recommendedProjects', 'metatags'));
    }


    public function getCategoryProjects($link)
    {
        $category = Category::where('link_en', $link)->orwhere('link_ar', $link)->first();
        $projects = Project::where('status', 1)->where('category_id', $category->id)->get();
        $categories = Category::where('status',1)->where('home',1)->take(3)->get();

        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.products', compact('projects', 'metatags', 'category' ,'categories'));
    }

    public function getCategoryProducts($link){
        $category = Category::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $projects =Project::where('status',1)->where('category_id',$category->id)->get();
          $categories = Category::where('status',1)->where('home',1)->take(3)->get();
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.category_projects',compact('projects','metatags','category','categories'));
    }

    public function getCareersPage()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $careers = Career::where('status', 1)->orderBy('order', 'ASC')->get();
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.careers', compact('careers', 'metatags', 'lang'));
    }
    public function getDatesPage()
    {
        $dates = Date::where('status', 1)->get();
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.dates', compact('dates', 'metatags'));
    }
    public function getPhonesPage()
    {
        $phones = Phone::where('status', 1)->get();
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.phones', compact('phones', 'metatags'));
    }
    public function applyTrainingPage()
    {
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.apply-training', compact('metatags'));
    }

    public function developersPage()
    {
        ////// seo script//////
        list($metatags) = $this->projectsPageSeo();
        return view('website.developers', compact('metatags'));
    }


    public function saveCareerApplication(Request $request)
    {
        $request->validate([
            'name' => 'required|max:150',
            'email' => 'nullable|email',
            'notes' => 'nullable',
            'position' => 'nullable',
            'phone' => 'required|regex:/^[\+]?[0-9]{9,15}$/',
            'file' => 'nullable|mimes:pdf,docx|max:10240',
        ]);

        $add = new CareerApplication();
        $add->name = $request->name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->notes = $request->notes;
        $add->position = $request->position;
        dd($request);

        if ($request->file('file')) {
            $fileName = time() . '_' . $request->file('file')->getClientOriginalName();

            $folderPath = base_path('uploads/careers/pdfs');

            $file = $request->file('file')->move($folderPath, $fileName);

            $add->file = $fileName;
        }

        $add->save();

        return back()->with(['success' => trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);
    }



    public function saveTrainingApplications(Request $request)
    {
        $request->validate([
            'name' => 'required|max:150',
            'email' => 'required|email',
            'notes' => 'required',
            'phone' => 'required|regex:/(01)[0-9]{9}/',
        ]);

        $add = new TrainingApplication();
        $add->name = $request->name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->notes = $request->notes;
        $add->training = $request->training;
        $add->save();

        //         $data = array('contact' => $contact);
        //         $setting = Setting::first();
        // 	    Mail::send('emails/contact_email', $data, function($msg) use ($setting) {
        //   			$msg->to([$setting ->contact_email,'support@waelsakrplastic.com'], 'Booking Appointement')->subject('Booking');
        //   			$msg->cc(['begroup.seo@gmail.com','ahmed.essam.be@gmail.com']);
        //   			$msg->from(config('mail.from.address'),config('mail.from.name'));
        // 		});
        return back()->with(['success' => trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);

    }

    //////////////////// search auto complete function ///////////////////
    public function autoCompletesearch()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $text = $_GET['phrase'];
        $projects = Project::where('name_en', 'like', '%' . $text . '%')->orwhere('name_ar', 'like', '%' . $text . '%')->where('status', 1)->get();
        $results = [];
        foreach ($projects as $query) {
            if ($lang == 'en') {
                $results[] = ['name' => $query->name_en];
            } else {
                $results[] = ['name' => $query->name_ar];
            }
        }
        return response()->json($results);
    }

    public function getCategories(){
        $categories = Category::where('parent_id',0)->where('status',1)->get();

        list($metatags) = $this->projectsPageSeo();

        return view('website.categories',compact('categories' , 'metatags' ));
    }
    public function getSubCategories($link = null)
    {
        $category = Category::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $category_id = $category->id ?? null;
        if (isset($category_id)) {
            $sub_categories = Category::where('parent_id', $category_id)
                ->where('status', 1)
                ->get();
        } else {
            $sub_categories = Category::where('parent_id','!=' ,0)
                ->where('status', 1)
                ->get();
        }
    
        return view('website.sub-category', compact('sub_categories'));
    }

     public function maintenance(){
        $categories =  Category::where('status',1)->get();
        // list($schema, $metatags) = $this->contactUsPageSeo();
        return view('website.maintenance',compact('categories'));
    }


}
