
<form action="<?php echo e(LaravelLocalization::localizeUrl('save/contact-us')); ?>" method="POST" class="ajax-submit" id="contactForm" novalidate>
    <?php echo csrf_field(); ?>
    <div class="row">
        <div id="success-message" style="color: green;"></div>
        <div class="row">
            <div class="col-md-12 form-group">
                <input name="name" type="text" placeholder="Your Name *">
                <div class="alert alert-danger print-error-msg" id="error-name" style="display:none; color: red;"></div>
                <div class="col-md-12 form-group">
                    <input name="email" type="email" placeholder="Your Email *">
                    <div class="alert alert-danger print-error-msg" id="error-email" style="display:none; color: red;">
                    </div>
                </div>
                <div class="col-md-12 form-group">
                    <input name="Phone" type="text" placeholder="Phone Number *">
                    <div class="alert alert-danger print-error-msg" id="error-phone" style="display:none; color: red;">
                    </div>
                </div>
                <div class="col-md-12 form-group">
                    <textarea name="message" id="message" cols="30" rows="4" placeholder="Message *"></textarea>
                    <div class="alert alert-danger print-error-msg" id="error-message"
                        style="display:none; color: red;"></div>
                </div>
                <div class="col-md-12">
                    <input name="submit" type="submit" id="submit" value="Send Message">
                </div>
            </div>
        </div>
    </div>
</form>
<?php $__env->startSection('script'); ?>
    <script>
        $('#contactForm').on('submit', function(e) {
            e.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);
            console.log("Form action URL:", $(this).attr('action'));
            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#contactForm')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if (messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index, message) {
                            const errorMessage = $("<div>").text(message);
                            errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\OSPanel\domains\albadr\resources\views/website/web-partials/contactform.blade.php ENDPATH**/ ?>