@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_head_headers')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.progresses')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/progresses')}}">{{trans('home.progresses')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.edit_progresses')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{trans('home.edit_progresses')}}</h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            {!! Form::open(['method'=>'PATCH','url' => 'admin/progresses/'.$progress->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="">{{trans('home.title_en')}}</label>
                                        <input class="form-control" name="title_en" type="text" placeholder="{{trans('home.title_en')}}"  value="{{$progress->title_en}}" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="">{{trans('home.title_ar')}}</label>
                                        <input class="form-control" name="title_ar" type="text" placeholder="{{trans('home.title_ar')}}"  value="{{$progress->title_ar}}" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="">{{trans('home.text_en')}}</label>
                                        <textarea class="form-control ckeditor-classic" name="text_en" value="{{$progress->text_en}}" placeholder="{{trans('home.text_en')}}"></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="">{{trans('home.text_ar')}}</label>
                                        <textarea class="form-control ckeditor-classic" name="text_ar" value="{{$progress->text_ar}}" placeholder="{{trans('home.text_ar')}}"></textarea>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label class="">{{trans('home.type')}}</label>
                                        <select class="form-control" name="type" data-trigger  value="{{$progress->type}}">
                                            <option></option>
                                            <option vlaue="home" {{($progress->type=='home'?'selected':'')}}>{{__('home.home')}}</option>
                                            <option vlaue="about-us" {{($progress->type=='about-us'?'selected':'')}}>{{__('home.about-us')}}</option>
                                        </select>
                                        </div>
                                    <div class="col-md-2 mb-3">
                                        <label class="">{{trans('home.number')}}</label>
                                        <input class="form-control" name="number" type="number" placeholder="{{trans('home.number')}}"  value="{{$progress->number}}" required>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label for="order">{{trans('home.order')}}</label>
                                        <input type="number" min="0"  class="form-control" placeholder="{{trans('home.order')}}" name="order" value="{{$progress->order}}">
                                    </div>


                                </div>
                                <div class="form-group">
                                    <div class="form-check d-flex">
                                        <input type="checkbox" value="1" name="status" id="switch" switch="success" {{($progress->status == 1)? 'checked':''}} />
                                        <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                        <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                    <a href="{{url('/admin/progresses')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
