@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_galleryImage')}}</title>
@endsection
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.galleryImages')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/gallery-images')}}">{{trans('home.galleryImages')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_galleryImage')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_galleryImage')}}</h6>
                        </div>
                        {!! Form::open(['method'=>'PATCH','url' => 'admin/gallery-images/'.$galleryImage->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.image')}}</label>
                                    <input class="form-control" name="img" type="file" >
                                </div>
                                
                                <div class="form-group col-md-3"> 
                                    <label for="type">{{trans('home.type')}}</label>
                                    <select class="form-control select2 type" name="type">
                                        <option value ="general" {{($galleryImage->type)?'selected':''}}>{{trans('home.general')}}</option>
                                        <option value ="certificate" {{($galleryImage->type)?'selected':''}}>{{trans('home.before-and-after')}}</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-3">
                                    <fieldset class="form-group">
                                        <label for="order">{{trans('home.order')}}</label>
                                        <input type="number" min="1"  class="form-control" placeholder="{{trans('home.order')}}" name="order" value="{{$galleryImage->order}}" >
                                    </fieldset>
                                </div>
                            
                                @if($galleryImage->img)
                                    <div class="form-group col-md-12">
                                        <img src="{{url('uploads/galleryImages/source/'.$galleryImage->img)}}"  width="150px" height="150px"/>
                                    </div>
                                @endif
                                
                                <div class="form-group col-md-6">
                                    <label for="text_en">{{trans('home.text_en')}}</label>
                                    <textarea class="form-control " name="text_en" placeholder="{{trans('home.text_en')}}" maxlength="50">{{$galleryImage->text_en}}</textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="text_ar">{{trans('home.text_ar')}}</label>
                                    <textarea class="form-control " name="text_ar" placeholder="{{trans('home.text_ar')}}" maxlength="50">{{$galleryImage->text_ar}}</textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" {{($galleryImage->status == 1)? 'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                    </label>
                                </div>
                                
                                <div class="form-group col-md-3"> 
                                    <label for="type">{{trans('home.services')}}</label>
                                    <select class="form-control select2 type" name="sevice_id">
                                        <option value ="" >{{trans('home.Choose-Service')}}</option>
                                        @foreach ($services as $service)
                                            <option value ="{{$service->id}}">{{(app()->getLocale() == 'en')? $service->name_en : $service->name_ar}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{url('/admin/gallery-images')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>

                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
