
<title><?php echo e(trans('home.edit_role')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.roles')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/roles')); ?>"><?php echo e(trans('home.roles')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_role')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- Row-->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.edit_role')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">

                            <form method="POST" action="<?php echo e(url('admin/roles/' . $role->id)); ?>" enctype="multipart/form-data" data-toggle="validator">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <div class="row">

                                    <div class="col-md-12 mb-3">
                                        <label for="name"><?php echo e(trans('home.name')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.name')); ?>" name="name" required value="<?php echo e($role->name); ?>">
                                    </div>

                                    <div class="form-group col-md-12">
                                        <label for="helperText"><?php echo e(trans('home.permissions')); ?></label>
                                        <div class="permissions">
                                            <select class="form-control  choices-multiple-remove-button" name="permissions[]" multiple>
                                                <?php $__currentLoopData = $allPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($permission->name); ?>" <?php if(in_array($permission->name,$rolePermissions)): ?> selected <?php endif; ?>><?php echo e($permission->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4 mt-4 mb-0">
                                        <input type="checkbox" name="all_permissions" value="1" class="form-check-input form-check-input" id="checkbox"> <?php echo e(trans('home.selectall')); ?>

                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/roles')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $("#checkbox").click(function() {
        if ($("#checkbox").is(':checked')) {
            $(".permissions").addClass("d-none");
        } else {
            $(".permissions").removeClass("d-none");
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/blooma/resources/views/admin/roles/editRole.blade.php ENDPATH**/ ?>