<?php

namespace App\Providers;

use App\Models\About;
use Illuminate\Support\Facades\Blade;
use App\Models\AboutStruc;
use App\Models\Career;
use App\Models\Album;
use App\Models\Date;
use App\Models\HomeSlider;
use App\Models\Progress;
use App\Models\Phone;
use App\Models\Project;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App;
use View;
use App\Models\Setting;
use App\Models\Title;
use App\Models\Configration;
use App\Models\MenuItem;
use App\Models\Page;
use Auth;
use App\Models\Category;
use App\Models\Service;
use App\Models\GalleryImage;
use App\Models\BeforeAfter;
use App\Models\Address;
use App\Models\SeoAssistant;
use App\Models\BlogCategory;
use App\Models\Writer;
use App\Models\Region;
use App\Models\Brand;
use App\Models\Team;
use App\Models\Partner;
use App\Helpers\Helper;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }



    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        ///////////////////////@truncate///////////////////
        Blade::directive('truncate', function ($expression) {
            return "<?php echo Helper::truncateHtml($expression); ?>";
        });
        ///////////////////////@truncate///////////////////

        Schema::defaultStringLength(191);
        \URL::forceScheme('https');

        view()->composer('*', function($view)
        {
            $setting = Setting::first();
            $seo = SeoAssistant::first();
            $writers = Writer::where('status',1)->get();
            $lang = \LaravelLocalization::getCurrentLocale();
            App::setlocale($lang);
            $blogCategories= BlogCategory::orderBy('id','desc')->get();
            $configration = Configration::where('lang',$lang)->first();
            $menus = MenuItem::where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $footerMenus = MenuItem::where('menu_id',2)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $pages = Page::where('status',1)->get();
            $menuServices = Service::where('status',1)->where('parent_id',0)->orderBy('order','ASC')->take(6)->get();
            $services  = Service::where('menu',1)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->take(6)->get();
            $albums = Album::where('status',1)->get();
            $galleryImages = GalleryImage::where('status',1)->orderBy('order','asc')->take(6)->get();
            $beforeAfters = BeforeAfter::where('status',1)->orderBy('order','asc')->take(6)->get();
            $projects = Project::where('status', 1)->where('recommended', 1)->get();
            $sliders = HomeSlider::where('lang', $lang)->where('status', 1)->get();
            $teams = Team::where('lang', $lang)->where('status', 1)->get();


            $menuCategories = Category::where('menu',1)->where('status',1)->get();
            $brands = Brand::where('status',1)->orderBy('order','ASC')->get();
            $partners = Partner::where('status',1)->orderBy('order','ASC')->get();
            $lang=\App::getLocale();
            $addresses = Address::where('status',1)->get();
            $statements = Career::where('status',1)->where('type','header')->get();
            $dates = Date::where('status',1)->orderBy('order' , 'ASC')->get();
            $phones = Phone::where('status',1)->orderBy('order','ASC')->get();
            $progresses = Progress::where('status',1)->orderBy('order','ASC')->get();
            $progressesChunks = $progresses->chunk(3);
            // dd($titles);
            $title = Title::first();
            $custom_products = Project::where('status',1)->where('recommended',1)->get();
            $aboutStrucs  = AboutStruc::where('status',1)->get();
            $about = About::first();
            $secType  = new Career;
            $sliderCount = 1;
            $subServices = Service::whereNotNull('parent_id')->where('status', 1)->get();
            $types = ['header', 'careers','projects','about', 'services', 'gallery', 'contact', 'blogs', 'reviews', 'whyus', 'teams' , 'skills' , 'vedios' , 'aboutStruc','brand' , 'testimonial' , 'footer' , 'slider' ,'date' ];
            $titles = Title::where('status', 1)->whereIn('type', $types)->get();
            $aboutTitle = $titles->where('type' , 'about');
            $blogsTitle = $titles->where('type' , 'blogs');
            $contactTitle = $titles->where('type' , 'contact');
            $careersTitle = $titles->where('type' , 'careers');
            $projectsTitle = $titles->where('type' , 'projects');
            $servicesTitle = $titles->where('type' , 'services');
            $galleryTitle = $titles->where('type' , 'gallery');
            $reviewsTitle = $titles->where('type' , 'reviews');
            $whyusTitle = $titles->where('type' , 'whyus');
            $teamsTitle = $titles->where('type' , 'teams');
            $skillsTitle = $titles->where('type' , 'skills');
            $vediosTitle = $titles->where('type' , 'vedios');
            $aboutStrucTitle = $titles->where('type' , 'aboutStruc');
            $brandTitle = $titles->where('type' , 'brand');
            $testimonialTitle = $titles->where('type' , 'testimonial');
            $footerTitle = $titles->where('type' , 'footer');
            $sliderTitle = $titles->where('type' , 'slider');
            $dateTitle = $titles->where('type' , 'date');
            $headerTitle = $titles->where('type' , 'header');

            
            App::setlocale($lang);
            View::share('language', $lang);
            View::share('sliderCount', $sliderCount);
            View::share('services', $services);
            View::share('teams', $teams);
            View::share('subServices', $subServices);
            View::share('projects', $projects);
            View::share('sliders', $sliders);
            View::share('setting', $setting);
            View::share('titles', $titles);
            View::share('title', $title);
            View::share('aboutTitle', $aboutTitle);
            View::share('headerTitle', $headerTitle);
            View::share('blogsTitle', $blogsTitle);
            View::share('contactTitle', $contactTitle);
            View::share('careersTitle', $careersTitle);
            View::share('projectsTitle', $projectsTitle);
            View::share('servicesTitle', $servicesTitle);
            View::share('galleryTitle', $galleryTitle);
            View::share('reviewsTitle', $reviewsTitle);
            View::share('whyusTitle', $whyusTitle);
            View::share('teamsTitle', $teamsTitle);
            View::share('skillsTitle', $skillsTitle);
            View::share('vediosTitle', $vediosTitle);
            View::share('aboutStrucTitle', $aboutStrucTitle);
            View::share('brandTitle', $brandTitle);
            View::share('testimonialTitle', $testimonialTitle);
            View::share('footerTitle', $footerTitle);
            View::share('sliderTitle', $sliderTitle);
            View::share('dateTitle', $dateTitle);
            View::share('configration', $configration);
            View::share('menus', $menus);
            View::share('pages', $pages);
            View::share('lang', $lang);
            View::share('galleryImages', $galleryImages);
            View::share('beforeAfters', $beforeAfters);
            View::share('blogCategories', $blogCategories);
            View::share('addresses', $addresses);
            View::share('writers', $writers);
            View::share('seo', $seo);
            View::share('footerMenus', $footerMenus);
            View::share('menuCategories', $menuCategories);
            View::share('brands', $brands);
            View::share('partners', $partners);
            View::share('statements', $statements);
            View::share('dates', $dates);
            View::share('albums', $albums);
            View::share('phones', $phones);
            View::share('progresses', $progresses);
            View::share('custom_products', $custom_products);
            View::share('menuServices', $menuServices);
            View::share('aboutStrucs', $aboutStrucs);
            View::share('about', $about);
            View::share('secType' , $secType);
            View::share('progressesChunks', $progressesChunks);

        });
    }
}
