<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Title extends Model
{
    public static function setCurrentLang()
    {

        return app()->getLocale();
    }
    protected $table = 'titles';

    protected $guarded = [];

    public static function getSectionsTypesSelect()
    {
        return [
            '/'          => __('home.home'),
            'slider'   => __('home.slider'),
            'progresses'   => __('home.progresses'),
            'schools' => __('home.schools'),
            'testimonial' => __('home.testimonials'),
            'brands' => __('home.brands'),
            'partner' => __('home.partners'),
            'services' => __('home.services'),
            'gallery' => __('home.gallery'),
            'header' => __('home.header'),
            'teams' => __('home.teams'),
        ];
    }


    public function getTitleAttribute()
    {

        return $this->{'title_' . $this->setCurrentLang()};
    }

    public function getTitle1Attribute()
    {

        return $this->{'title1_' . $this->setCurrentLang()};
    }
    public function getTextAttribute()
    {

        return $this->{'text_' . $this->setCurrentLang()};
    }

    public function getImageAttribute()
    {
        // Check if the 'image' column has a value
        if ($this->attributes['image']) {
            return url('uploads/titles/source/' . $this->attributes['image']);
        }

        // Return a default image if the 'image' column is empty or null
        return url('resources/assets/back/images/noimage.jpg');
    }

    public static function Section($type)
    {
        return Self::where('type', $type)->first();
    }
}
