<title><?php echo e(trans('home.users')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.users')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.users')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/users/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <!-- End Page Header -->


        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>


        <div class="container-fluid">
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <div class="table-rep-plugin">
                        <div class="mb-0" data-pattern="priority-columns">
                            <table id="tech-companies-1" class="table table-striped text-center">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th><?php echo e(trans('home.id')); ?></th>
                                        <th><?php echo e(trans('home.image')); ?></th>
                                        <th><?php echo e(trans('home.name')); ?></th>
                                        <th><?php echo e(trans('home.email')); ?></th>
                                        <th><?php echo e(trans('home.phone')); ?></th>
                                        <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                        <th><?php echo e(__('home.edit')); ?></th>
                                        <th><?php echo e(__('home.delete')); ?>

                                            <div class="d-block">
                                                <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light" ><?php echo e(__('home.delete')); ?></a>
                                            <div>                                 
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($user->id); ?>">
                                            <td> 
                                                <?php if($user->id!=1): ?>
                                                    <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($user->id); ?>"/>
                                                <?php endif; ?>
                                            </td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->id); ?></a></td>
                                            <td>
                                                <a href="<?php echo e(route('users.edit', $user->id)); ?>">
                                                    <?php if($user->image): ?>
                                                        <img src="<?php echo e(url('\uploads\users\resize200')); ?>\<?php echo e($user->image); ?>" width="50" height="50">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="50" height="50">
                                                    <?php endif; ?>
                                                </a>
                                            </td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->f_name.' '.$user->l_name); ?></a></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->email); ?></a></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->phone); ?></a></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e(trans("home.$user->status")); ?></a></td>                                        
                                            <td> 
                                                <a type="button" class="btn btn-info waves-effect waves-light " 
                                                    href="<?php echo e(route('users.edit',$user->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                            </td>
                                            <td> 
                                                <?php if($user->id!=1): ?>
                                                    <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                                        data-id="<?php echo e($user->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>                 
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\drkorny\resources\views/admin/users/users.blade.php ENDPATH**/ ?>