<!-- Contact -->
<div class="contact section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <!-- Contact Info -->
                <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <h4 class="mb-4"><span><?php echo e($address->{'title_' . $lang}); ?></span></h4>
                    <a href="<?php echo e($address->map_url); ?>" target="_blank">
                        <p><?php echo e($address->{'address_' . $lang}); ?></p>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="phone"><a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><?php echo e($phone->phone); ?></a></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="mail mb-3"><a href="mailto:<?php echo e($setting->email); ?>"><?php echo e($setting->email); ?></a></div>
                <div class="social mt-2">
                    <?php if($setting->twitter): ?>
                        <a href="<?php echo e($setting->twitter); ?>"><i class="ti-twitter"></i></a>
                    <?php endif; ?>
                    <?php if($setting->instgram): ?>
                        <a href="<?php echo e($setting->instgram); ?>"><i class="ti-instagram"></i></a>
                    <?php endif; ?>
                    <?php if($setting->facebook): ?>
                        <a href="<?php echo e($setting->facebook); ?>"><i class="ti-facebook"></i></a>
                    <?php endif; ?>
                    <?php if($setting->youtube): ?>
                        <a href="<?php echo e($setting->youtube); ?>"><i class="ti-youtube"></i></a>
                    <?php endif; ?>
                    <?php if($setting->linkedin): ?>
                        <a href="<?php echo e($setting->linkedin); ?>"><i class="ti-linkedin"></i></a>
                    <?php endif; ?>
                    <?php if($setting->tiktok): ?>
                        <a href="<?php echo e($setting->tiktok); ?>"><i class="ti-tiktok"></i></a>
                    <?php endif; ?>
                </div>
            </div>
            <!-- form -->
            <div class="col-md-8">
                <h4 class="mb-4"><?php echo e(trans('home.contact_us')); ?></span></h4>
                <form method="post" class="contact__form"
                    action="<?php echo e(LaravelLocalization::LocalizeUrl('save/contact-us')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Form message -->
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success contact__msg" style="display: none" role="alert"> Your
                                message was sent successfully. </div>
                        </div>
                    </div>
                    <!-- Form elements -->
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <input name="name" type="text" placeholder="<?php echo e(__('home.name')); ?> *" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <input name="email" type="email" placeholder="<?php echo e(__('home.email')); ?> *">
                        </div>
                        <div class="col-md-12 form-group">
                            <input name="phone" type="number" placeholder="<?php echo e(__('home.phone')); ?> *" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <textarea name="message" id="message" cols="30" rows="4" placeholder="<?php echo e(__('home.message')); ?> *"></textarea>
                        </div>
                        <div class="col-md-12 mt-2">
                            <input name="submit" type="submit" value="<?php echo e(__('home.send')); ?>">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Maps -->
<div class="google-maps">
    <iframe src="<?php echo e($setting->map_url); ?>" style="border:0;" allowfullscreen="" loading="lazy"
        referrerpolicy="no-referrer-when-downgrade"></iframe>
</div>
<?php /**PATH /home/webtest2/public_html/trust/resources/views/website/section-partials/contactpage.blade.php ENDPATH**/ ?>