<?php if(Request::segment(2) != 'service'): ?>
<!-- Start Contact Info Area -->
<section class="contact-info-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-6">
                <div class="contact-info-box">
                    <div class="icon">
                        <i class="flaticon-pin"></i>
                    </div>
                    <h3><?php echo e(trans('home.addresses')); ?></h3>
                    <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span><a href="<?php echo e($address->map_url); ?>" target="_blank"><?php echo e($address->{'address_' .$lang}); ?></a></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="contact-info-box">
                    <div class="icon">
                        <i class="flaticon-phone-call"></i>
                    </div>

                    <h3><?php echo e(trans('home.phone')); ?></h3>
                    <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span><a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><?php echo e($phone->phone); ?></a></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 offset-lg-0 offset-md-3">
                <div class="contact-info-box">
                    <div class="icon">
                        <i class="flaticon-email"></i>
                    </div>

                    <h3><?php echo e(trans('home.email')); ?></h3>
                    <span><a href="mailto:<?php echo e($setting->contact_email); ?>"><?php echo e($setting->contact_email); ?></a></span>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Start Contact Info Area -->
<?php endif; ?>
<!-- Start Contact Area -->
<section class="contact-area ptb-100">
    <div class="container">
        <div class="contact-inner">
            <div class="row m-0">
                <div class="col-lg-7 col-md-12 p-0">
                    <div class="contact-form">
                        <h2><?php echo e(trans('home.Any Questions')); ?></h2>

                        <form id="contactForm" action="<?php echo e(url('save/contact-us')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group">
                                        <label><i class="flaticon-user"></i></label>
                                        <input type="text" name="name" id="name" class="form-control"
                                            required data-error="Please enter your name" placeholder="<?php echo e(trans('home.name')); ?>">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group">
                                        <label><i class="flaticon-phone-call"></i></label>
                                        <input type="text" name="phone" id="phone_number" required
                                            data-error="Please enter your number" class="form-control"
                                            placeholder="<?php echo e(trans('home.phone')); ?>">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <label><i class="flaticon-email"></i></label>
                                        <input type="email" name="email" id="email" class="form-control"
                                            required data-error="Please enter your email"
                                            placeholder="<?php echo e(trans('home.email')); ?>">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <label><i class="flaticon-list"></i></label>
                                        <textarea name="message" class="form-control" id="message" cols="30" rows="6" required
                                            data-error="Write your message" placeholder="<?php echo e(trans('home.message')); ?>"></textarea>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12">
                                    <button type="submit" class="btn btn-primary"><?php echo e(trans('home.send')); ?> <i
                                            class="fas fa-paper-plane"></i></button>
                                    <div id="msgSubmit" class="h3 text-center hidden"></div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-5 col-md-12 p-0">
                    <div id="map">
                        <iframe
                            src="<?php echo e($setting->map_url); ?>"
                            style="border:0;" allowfullscreen="" loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bg-map"><img src="<?php echo e(url('resources/assets/front/img/bg-map.png')); ?>" alt="image"></div>
</section>
<!-- End Contact Area -->
<?php /**PATH C:\OSPanel\domains\smilepro\resources\views/website/section-partials/contactpage.blade.php ENDPATH**/ ?>