{{-- <!--News Details Start-->
<section class="news-details">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-7">
                <div class="news-details__left">
                    <div class="news-details__img">
                        <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="image">
                    </div>
                    <div class="news-details__content">
                        <h3 class="news-details__title">{{ $blog->{'title_' . $lang} }}</h3>
                        <p class="news-details__text-1">{!! $blog->{'text_' . $lang} !!}</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-5">
                <div class="sidebar">
                    <div class="sidebar__single sidebar__post">
                        <h3 class="sidebar__title">{{ trans('home.related_blogs') }}</h3>
                        <ul class="sidebar__post-list list-unstyled">
                            @foreach ($blogs as $relatedBlogs)
                                <li>
                                    <div class="sidebar__post-image">
                                        <img src="{{ Helper::uploadedImagesPath('blogitems', $relatedBlogs->image) }}"
                                            alt="image">
                                    </div>
                                    <div class="sidebar__post-content">
                                        <h3>
                                            <a
                                                href="{{LaravelLocalization::LocalizeUrl('blog/' .$relatedBlogs->{'link_' . $lang}) }}">{{ $relatedBlogs->{'title_' . $lang} }}</a>
                                        </h3>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="Form-section mt-5">
                        <h2 class="section-title-six__title">{{ trans('home.contact_us') }}</h2>
                        <form method="POST" action="{{ LaravelLocalization::LocalizeUrl('save/contact-us') }}"
                            class="comment-one__form contact-form-validated" novalidate="novalidate">
                            @csrf
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="{{ trans('home.name') }}" name="name">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="{{ trans('home.phone') }}" name="phone">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="comment-form__input-box">
                                        <input type="email" placeholder="{{ trans('home.email') }}" name="email">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="comment-form__input-box text-message-box">
                                        <textarea name="message" placeholder="{{ trans('home.message') }}"></textarea>
                                    </div>
                                    <div class="comment-form__btn-box">
                                        <button type="submit"
                                            class="thm-btn comment-form__btn">{{ trans('home.send') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--News Details End--> --}}
<!-- Post -->
<section class="section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-8"> <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}"
                    class="mb-30" alt="image">
                <h2>{{ $blog->{'title_' . $lang} }}</h2>
                <p>
                    {!! $blog->{'text_' . $lang} !!}
                </p>
                <!-- Comments -->
            </div>
            <!-- Sidebar -->
            <div class="col-md-4">
                <div class="blog2-sidebar row">
                    <div class="col-md-12">
                        <div class="widget search">
                            <form method="GET" action="{{ url('searchResult') }}">
                                <input type="text" name="search_input" placeholder="Type here ...">
                                <button type="submit"><i class="ti-search" aria-hidden="true"></i></button>
                            </form>
                        </div>
                    </div>
                    <div class="right-sidebar">
                        <div class="right-sidebar item">
                            <h3>{{ trans('home.get_in_touch') }}</h3>
                            <form method="post" class="right-sidebar item-form"
                                action="{{ LaravelLocalization::LocalizeUrl('save/contact-us') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <input name="name" type="text" placeholder="Full Name" required>
                                    </div>
                                    <div class="col-md-12 form-group">
                                        <input name="phone" type="number" placeholder="Phone" required>
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <input name="email" type="email" placeholder="Email Address">
                                    </div>
                                    <div class="col-md-6 form-group input1_inner">
                                        <input name="date" type="text" class="form-control input datepicker"
                                            placeholder="Travel Date" required>
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <input name="adults" type="number" placeholder="Adults" required>
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <input name="children" type="number" placeholder="Children" required>
                                    </div>
                                    <div class="col-md-12 form-group">
                                        <textarea name="message" id="message" cols="30" rows="4" placeholder="Your Enquiry"></textarea>
                                    </div>
                                    <div class="col-md-12">
                                        <button class="butn-dark"><a href="#0"><span>Book Now</span></a></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="widget">
                            <div class="widget-title">
                                <h6>{{ trans('home.related_blogs') }}</h6>
                            </div>
                            <ul class="recent">
                                @foreach ($blogs as $blogRelatd)
                                    <li>
                                        <div class="thum"> <img src="{{ Helper::uploadedImagesPath('blogitems', $blogRelatd->image) }}" alt="image"> </div> <a
                                            href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blogRelatd->{'link_' . $lang}) }}">{{ $blogRelatd->{'title_' . $lang} }}</a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
