<!DOCTYPE html>
<html lang="en" dir="ltr">



<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('title', 'Prekers'); ?>
    <?php echo $__env->yieldContent('meta'); ?>
    <title>prekers</title>
    
    <!-- Place favicon.ico in the root directory -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('uploads/settings/source/' . $configration->fav_icon)); ?>">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=El+Messiri:wght@400..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

    <!-- CSS here -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('font-awesome-pro.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('spacing.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('main.css')); ?>">
      <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('mainrtl.css')); ?>">
    <?php endif; ?>
    <!--====== USEFULL META ======-->
</head>

<body>
    <!-- pre loader area start -->
    <!--<div id="loading">-->
    <!--    <div class="loader-mask">-->
    <!--        <div class="loader">-->
    <!--            <div></div>-->
    <!--            <div></div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
    <!-- pre loader area end -->
    

    <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($index == 0): ?>
            <a href="tel:+2<?php echo e($setting->mobile); ?>" class="float-call">
                <i class="fal fa-phone" aria-hidden="true"></i>
            </a>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php if($setting->whatsapp): ?>
        <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" class="float-whts" target="_blank">
            <i class="fab fa-whatsapp" aria-hidden="true"></i>
        </a>
    <?php endif; ?>

    <!-- back to top start -->
    <div class="back-to-top-wrapper">
        <button id="back_to_top" type="button" class="back-to-top-btn">
            <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M11 6L6 1L1 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                    stroke-linejoin="round" />
            </svg>
        </button>
    </div>
    <!-- back to top end -->
    <!-- offcanvas area start -->
    <div class="offcanvas__area">
        <div class="offcanvas__close">
            <button class="offcanvas__close-btn offcanvas-close-btn">
                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                    <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
        <div class="offcanvas__wrapper">
            <div class="offcanvas__content">
                <div class="offcanvas__top mb-40">
                    <div class="offcanvas__logo">
                        <a href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>">
                            <img data-width="120" src="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>" alt="logo">
                        </a>
                    </div>
                </div>

                <div class="tp-offcanvas-menu fix d-xl-none mb-30">
                    <nav></nav>
                </div>

                <div class="offcanvas__contact d-none d-xl-block">
                    <div class="offcanvas__text mb-30">
                        <p><?php echo $configration->app_about; ?></p>
                    </div>
                    <div class="offcanvas__gallery mb-30">
                        <h4 class="offcanvas__title"><?php echo e(__('home.gallery')); ?></h4>

                    </div>
                </div>
                <div class="offcanvas-info mb-30">
                    <h4 class="offcanvas__title"><?php echo e(__('home.contact-us')); ?></h4>
                    <div class="offcanvas__contact-content d-flex">
                        <div class="offcanvas__contact-content-icon">
                            <i class="fa-sharp fa-solid fa-location-dot"></i>
                        </div>
                        <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($index == 0): ?>
                        <div class="offcanvas__contact-content-content">
                            <a
                                href="<?php echo e($address->map_url); ?>"><?php echo e($address->{'title_'.$lang}); ?> </a>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <?php if($setting->email): ?>
                    <div class="offcanvas__contact-content d-flex">
                        <div class="offcanvas__contact-content-icon">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div class="offcanvas__contact-content-content">
                            <a href="mailto:<?php echo e($setting->email); ?>"> <?php echo e($setting->email); ?> </a>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="offcanvas__contact-content d-flex">
                        <div class="offcanvas__contact-content-icon">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($index == 0): ?>
                                <div class="offcanvas__contact-content-content">
                                    <a href="<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"> <?php echo e($phone->phone); ?></a>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="offcanvas__social">
                    <?php if($setting->facebook): ?>
                        <a class="icon facebook" href="<?php echo e($setting->facebook); ?>"><i
                                class="fab fa-facebook-f"></i></a>
                    <?php endif; ?>
                    <?php if($setting->twitter): ?>
                        <a class="icon twitter" href="<?php echo e($setting->twitter); ?>"><i class="fab fa-twitter"></i></a>
                    <?php endif; ?>
                    <?php if($setting->youtube): ?>
                        <a class="icon youtube" href="<?php echo e($setting->youtube); ?>"><i class="fab fa-youtube"></i></a>
                    <?php endif; ?>
                    <?php if($setting->linkedin): ?>
                        <a class="icon linkedin" href="<?php echo e($setting->linkedin); ?>"><i class="fab fa-linkedin"></i></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="body-overlay"></div>
    <!-- offcanvas area end -->
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Start Go Top Section -->
    
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <!-- jQuery Min JS -->
    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('vendor/jquery.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap-bundle.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper-bundle.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('purecounter.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('imagesloaded-pkgd.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope-pkgd.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('ajax-form.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-element-bundle.min.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <!--=====JQUERY=======-->
    
    <?php echo $__env->yieldContent('script'); ?>
    
      <script>
    var swiper = new Swiper(".mySwiper", {
      slidesPerView: 3,
      spaceBetween: 30,
      freeMode: true,
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
    });
  </script>
</body>

</html>
<?php /**PATH /home/webtest/public_html/prekers/resources/views/layouts/app.blade.php ENDPATH**/ ?>