<title><?php echo e(trans('home.edit_galleryVideo')); ?></title>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.edit_galleryVideo')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/gallery-videos')); ?>"><?php echo e(trans('home.galleryVideos')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_galleryVideo')); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/gallery-videos/'.$galleryVideo->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class=""><?php echo e(trans('home.image')); ?></label>
                                    <input class="form-control" name="img" type="file" >
                                </div>
                                
                                <div class="col-md-3 mb-3">
                                    <fieldset class="form-group">
                                        <label for="order"><?php echo e(trans('home.order')); ?></label>
                                        <input type="number" min="1"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($galleryVideo->order); ?>" >
                                    </fieldset>
                                </div> 
                                 
                                 <div class="col-md-6">
                                 <label for="section_type"><?php echo e(trans('home.choosesection_type')); ?></label>
                                    <select name="section_type" id="section_type" class="form-control">
                                        <option value="about-us" <?php echo e(old('section_type', $galleryVideo->section_type) == 'about-us' ? 'selected' : ''); ?>>about-us</option>
                                        <option value="testimonials" <?php echo e(old('section_type' , $galleryVideo->section_type) == 'testimonials' ? 'selected' : ''); ?>>testimonials</option>
                                         <option value="teams" <?php echo e(old('section_type' , $galleryVideo->section_type) == 'teams' ? 'selected' : ''); ?>>teams</option>
                                         <option value="faq" <?php echo e(old('section_type' , $galleryVideo->section_type) == 'faq' ? 'selected' : ''); ?>>faq</option>
                                    </select>
                                    </div>
                                    <div class="col-md-6" id="row_id" style="display: none;">
                                        <label for="team_id" class="form-label"><?php echo e(__('home.choose')); ?></label>
                                        <select class="form-select" id="row_id" name="row_id">
                                            <option value=""><?php echo e(__('home.choose')); ?></option>
                                            <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($team->id); ?>"><?php echo e($team->{'name_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                 <label for="video_type"><?php echo e(trans('home.choosevideo_type')); ?></label>
                                    <select name="video_type" id="video_type" class="form-control">
                                        <option value="link"  <?php echo e(old('video_type',$galleryVideo->video_type) == 'link' ? 'selected' : ''); ?>>youtube_link</option>
                                        <option value="file"  <?php echo e(old('video_type',$galleryVideo->video_type) == 'file' ? 'selected' : ''); ?>>upload video</option>
                                    </select>
                              </div>
                                <div class="col-md-9 mb-3"  id="youtube_link" style="display: none;">
                                    <fieldset class="form-group">
                                        <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link" value="<?php echo e($galleryVideo->youtube_link); ?>" id="youtube_url">
                                    </fieldset>
                                </div>
                                <div class="col-md-9 mb-3"  id="video_upload" style="display: none;">
                                    <fieldset class="form-group">
                                        <label for="youtube_link"><?php echo e(trans('home.uploadvideo')); ?></label>
                                        <input type="file"  class="form-control" placeholder="<?php echo e(trans('home.uploadvideo')); ?>" name="video_upload" value="<?php echo e($galleryVideo->video_upload); ?>" id="video_file" accept="video/mp4">
                                    </fieldset>
                                </div>
                                

                                <div class="col-md-6 mb-3">
                                    <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                    <textarea class="form-control ckeditor-classic" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" maxlength="50"><?php echo e($galleryVideo->text_en); ?></textarea>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                    <textarea class="form-control ckeditor-classic" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" maxlength="50"><?php echo e($galleryVideo->text_ar); ?></textarea>
                                </div>
                            </div>
                            <div class="form-group col-3">

                                <div class="form-check d-flex">
                                    <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($galleryVideo->status == 1)? 'checked':''); ?>  />
                                    <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                <a href="<?php echo e(url('/admin/gallery-videos')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                             <div class="row">
                            <?php if($galleryVideo->youtube_link): ?>
                                    <div class=" col-md-12 m-2 mt-3">
                                        <iframe width="400" height="150"
                                            src="<?php echo e($galleryVideo->youtube_link); ?>">
                                        </iframe>
                                    </div>
                                    <?php else: ?>
                                    <div class=" col-md-3 mt-3">
                                        <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                    </div>
                                <?php endif; ?>
                                 <?php if($galleryVideo->video_upload): ?>
                                    <div class=" col-md-12 m-2 mt-3">
                                        <iframe width="400" height="150"
                                            src="<?php echo e(asset('/uploads/videos/source/' . $galleryVideo->video_upload)); ?>">
                                        </iframe>
                                    </div>
                                <?php else: ?>
                                    <div class=" col-md-3 mt-3">
                                        <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                    </div>
                                <?php endif; ?>
                                </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
document.getElementById('video_type').addEventListener('change', function() {
    if (this.value == 'link') {
        document.getElementById('youtube_link').style.display = 'block';
        document.getElementById('video_upload').style.display = 'none';
    } else {
        document.getElementById('video_upload').style.display = 'block';
        document.getElementById('youtube_link').style.display = 'none';
    }
});
document.getElementById('section_type').addEventListener('change', function() {
    if (this.value == 'teams') {
        document.getElementById('row_id').style.display = 'block';
    } else{
        document.getElementById('row_id').style.display = 'none';
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\prekers\resources\views/admin/galleryVideos/editGalleryVideo.blade.php ENDPATH**/ ?>