@extends('layouts.admin')

@section('meta')

    <title>{{ trans('home.editsubheader') }}</title>

@endsection

@section('content')

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="page-title-box d-sm-flex align-items-center justify-content-between">

                    <h4 class="mb-sm-0 font-size-18">{{ trans('home.subheader') }}</h4>



                    <div class="page-title-right">

                        <ol class="breadcrumb m-0">

                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>

                            <li class="breadcrumb-item"><a

                                    href="{{ url('/admin/subheaders') }}">{{ trans('home.subheader') }}</a></li>

                            <li class="breadcrumb-item active">{{ trans('home.editsubheader') }}</li>

                        </ol>

                    </div>



                </div>

            </div>

        </div>

        <!-- Row-->

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-header">

                        <h4 class="card-title">{{ trans('home.editsubheader') }}</h4>

                    </div>

                    <div class="card-body p-4">

                        <div class="row">

                            <div class="col-lg-12">

                                <form action="{{ route('subheaders.update', $subheader->id) }}" method="POST"

                                    enctype="multipart/form-data">

                                    @csrf

                                    @method('put')

                                    <div class="row">

                                        <div class="col-md-3 mb-3">

                                            <label>{{ trans('home.title_en') }}</label>

                                            <input type="text" name="title_en" class="form-control"

                                                placeholder="{{ trans('home.title_en') }}"

                                                value="{{ $subheader->title_en }}">

                                        </div>

                                        <div class="col-md-3 mb-3">

                                            <label>{{ trans('home.title_ar') }}</label>

                                            <input type="text" name="title_ar" class="form-control"

                                                placeholder="{{ trans('home.title_ar') }}"

                                                value="{{ $subheader->title_ar }}">

                                        </div>

                                        <div class="col-md-3 mb-3">

                                            <label class="">{{ trans('home.order') }}</label>

                                            <input type="number" name="order" class="form-control"

                                                placeholder="{{ trans('home.order') }}" value="{{$subheader->order}}">

                                        </div>

                                         <div class="form-group

                                                col-md-6 ">

                                                        <label for="text_en">{{ trans('home.text_en') }}</label>

                                                        <textarea name="text_en" class="form-control ckeditor-classic" placeholder="{{ trans('home.text_en') }}">{!! $subheader->text_en !!}</textarea>

                                                    </div>

                                                    <div class="form-group col-md-6 ">

                                                        <label for="text_ar">{{ trans('home.text_ar') }}</label>

                                                        <textarea name="text_ar" class="form-control ckeditor-classic" placeholder="{{ trans('home.text_ar') }}">{!! $subheader->text_ar !!}</textarea>

                                                    </div>

                                                    <div class="col-md-6 mb-3">

                                                        <label for="type">{{ trans('home.type') }}</label>

                                                        <select name="type" class="form-control" data-trigger required>

                                                            <option {{ $subheader->type == 'about' ? 'selected' : '' }} value="about">{{ trans('home.about-us') }}</option>

                                                            <option {{ $subheader->type == 'services' ? 'selected' : '' }} value="services">{{ trans('home.services') }}</option>

                                                            <option {{ $subheader->type == 'gallery' ? 'selected' : '' }} value="gallery">{{ trans('home.gallery') }}</option>

                                                            <option {{ $subheader->type == 'contact' ? 'selected' : '' }} value="contact">{{ trans('home.contact-us') }}</option>

                                                            <option {{ $subheader->type == 'blogs' ? 'selected' : '' }} value="blogs">{{ trans('home.blogs') }}</option>

                                                            <option {{ $subheader->type == 'reviews' ? 'selected' : '' }} value="reviews">{{ trans('home.reviews') }}</option>

                                                            <option {{ $subheader->type == 'whyus' ? 'selected' : '' }} value="whyus">{{ trans('home.whyus') }}</option>

                                                            <option {{ $subheader->teams == 'whyus' ? 'selected' : '' }} value="teams">{{ trans('home.teams') }}</option>

                                                            <option {{ $subheader->type == 'projects' ? 'selected' : '' }} value="projects">{{ trans('home.projects') }}</option>

                                                            <option {{ $subheader->type == 'awards' ? 'selected' : '' }} value="awards">{{ trans('home.awards') }}</option>

                                                            <option {{ $subheader->type == 'brands' ? 'selected' : '' }} value="brands">{{ trans('home.brands') }}</option>

                                                        </select>

                                                    </div>

                                                    <div class="col-md-6 mb-3">

                                                        <label class="">{{ trans('home.number') }}</label>

                                                        <input type="number" name="number" class="form-control" value="{{$subheader->number}}"

                                                            placeholder="{{ trans('home.number') }}">

                                                    </div>

                                                    <div class="col-md-6 mb-3">

                                                        <label for="formFile" class="form-label">{{ __('home.chooseImage') }}</label>

                                                        <input type="file" name="image" placeholder="{{ __('home.chooseImage') }}" value="{{$subheader->image}}"

                                                            class="form-control" id="formFile">

                                                    </div>

                                                    <div class="form-group">

                                                        <div class="form-check d-flex">

                                                            <input type="checkbox" name="status" value="1" id="switch"

                                                                switch="success"  {{$subheader->status==1 ?'checked':''}} />

                                                            <label for="switch" data-on-label="{{ trans('home.yes') }}"

                                                                data-off-label="{{ trans('home.no') }}"></label>

                                                            <label class="form-check-label mx-3"

                                                                for="switch">{{ trans('home.publish') }}</label>

                                                        </div>

                                                    </div>

                                                    <div class="mt-4">

                                                        <button type="submit" class="btn btn-primary w-md">{{ trans('home.save') }}</button>

                                                        <a href="{{ url('/admin/subheaders') }}"><button type="button"

                                                                class="btn btn-danger mr-1"><i class="icon-trash"></i>

                                                                {{ trans('home.cancel') }}</button></a>

                                                    </div>

                                                    

                                            </form>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

@endsection

