@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_head_headers')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.head_headers')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/phones')}}">{{trans('home.head_headers')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.edit_head_headers')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{trans('home.edit_head_headers')}}</h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            {!! Form::open(['method'=>'PATCH','url' => 'admin/phones/'.$phone->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                <div class="row">
                                    <div class="col-md-2 mb-3">
                                        <label class="">{{trans('home.country_code')}}</label>
                                        <input class="form-control" name="code" type="text" placeholder="{{trans('home.country_code')}}"  value="{{$phone->code}}" required>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label class="">{{trans('home.number_phone')}}</label>
                                        <input class="form-control" name="phone" type="text" placeholder="{{trans('home.number_phone')}}"  value="{{$phone->phone}}" required>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label for="order">{{trans('home.order')}}</label>
                                        <input type="number" min="0"  class="form-control" placeholder="{{trans('home.order')}}" name="order" value="{{$phone->order}}">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="form-check d-flex">
                                        <input type="checkbox" value="1" name="status" id="switch" switch="success" {{($phone->status == 1)? 'checked':''}} />
                                        <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                        <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                    <a href="{{url('/admin/phones')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
