<?php

namespace App\Providers;

use App\Models\About;
use App\Models\AboutStruc;
use App\Models\Career;
use App\Models\Date;
use App\Models\Progress;
use App\Models\Phone;
use App\Models\Project;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App;
use View;
use App\Models\Setting;
use App\Models\Configration;
use App\Models\MenuItem;
use App\Models\Page;
use Auth;
use App\Models\Category;
use App\Models\Footer;
use App\Models\Service;
use App\Models\GalleryImage;
use App\Models\Address;
use App\Models\SeoAssistant;
use App\Models\BlogCategory;
use App\Models\Writer;
use App\Models\Region;
use App\Models\Brand;
use App\Models\BlogItem;
use App\Models\Team;
use App\Models\Subheader;
use App\Models\Album;
use App\Models\HomeSlider;
use App\Models\GalleryVideo;
use App\Models\IntroSlider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
        Schema::defaultStringLength(191);
        \URL::forceScheme('https');

        view()->composer('*', function($view)
        {
            $setting = Setting::first();
            $seo = SeoAssistant::first();
            $writers = Writer::where('status',1)->get();
            $lang = \LaravelLocalization::getCurrentLocale();
            App::setlocale($lang);
            $blogCategories= BlogCategory::orderBy('id','desc')->get();
            $configration = Configration::where('lang',$lang)->first();
            $menus = MenuItem::where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $footerMenus = MenuItem::where('menu_id',2)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->get();
            $pages = Page::where('status',1)->get();
            $menuServices = Service::where('status',1)->where('parent_id',0)->orderBy('order','ASC')->take(6)->get();

            $services  = Service::where('menu',1)->where('status',1)->where('parent_id',0)->orderBy('order','ASC')->take(3)->get();

            $menuCategories = Category::where('menu',1)->where('status',1)->get();
            $brands = Brand::where('status',1)->get();
            $lang=\App::getLocale();

            $addresses = Address::where('status',1)->take(3)->get();
            $twoaddresses = Address::where('status',1)->take(2)->get();
            $lastAddress = Address::where('status', 1)->first();

            $statements = Career::where('status',1)->where('type','header')->get();
            $dates = Date::where('status',1)->get();
            $phones = Phone::where('status',1)->orderBy('order','ASC')->get();
            $progresses = Progress::where('status',1)->orderBy('order','ASC')->get();
            $progress = Progress::where('status',1)->orderBy('order','ASC')->first();
            $custom_products = Project::where('status',1)->where('recommended',1)->get();
            $aboutStrucs  = AboutStruc::where('status',1)->where('lang',$lang)->get();
            $about = About::first();
            $footer = Footer::first();
            $blogs = BlogItem::where('status',1)->get();
            $phone = Phone::where('status', 1)->first();

            $headerSections = Career::where('status',1)->orderBy('order','ASC')->get();
            $sec  = new Career;
            $teams = Team::where('status',1)->get();
            $subheader = new Subheader;
            $subheaders = Subheader::where('status',1)->orderBy('order','ASC')->get();
            $albumwhyus = Album::where('status',1)->where('type','images')->where('section','whyus')->get();
            $albumabout = Album::where('status',1)->where('type','images')->where('section','about')->get();
            $albumImages = new Album();
            $projects = Project::where('status',1)->where('recommended',1)->take(5)->get();
            $sliders = HomeSlider :: where('lang',$lang)->where('status',1)->get();
            $introslider = IntroSlider::where('lang',$lang)->where('status',1)->where('order',1)->first();
            $video =GalleryVideo::where('status',1)->orderBy('order','asc')->first();
            $aboutvideos =GalleryVideo::where('status',1)->where('section_type','about-us')->orderBy('order','asc')->get();
            $testvideos =GalleryVideo::where('status',1)->where('section_type','testimonials')->orderBy('order','asc')->get();
            $faqvideos =GalleryVideo::where('status',1)->where('section_type','faq')->orderBy('order','asc')->get();
             $teamvideos =GalleryVideo::where('status',1)->where('section_type','teams')->orderBy('order','asc')->get();

        $galleryImages = GalleryImage::where('status',1)->orderBy('order','asc')->get();
//            $menubrands  = Brand::where('status',1)->get();
//            $footerServices = Service::where('parent_id',0)->where('status',1)->orderBy('order')->orderBy('name_ar')->take(6)->get();;
//            $regions = Region::where('status',1)->where('available_units',1)->get();

            App::setlocale($lang);
            View::share('language', $lang);
            View::share('services', $services);
            View::share('setting', $setting);
            View::share('configration', $configration);
            View::share('menus', $menus);
            View::share('pages', $pages);
            View::share('lang', $lang);
            View::share('blogCategories', $blogCategories);
            View::share('addresses', $addresses);
            View::share('writers', $writers);
            View::share('seo', $seo);
            View::share('footerMenus', $footerMenus);
            View::share('menuCategories', $menuCategories);
            View::share('brands', $brands);
            View::share('statements', $statements);
            View::share('dates', $dates);
            View::share('phones', $phones);
            View::share('progresses', $progresses);
            View::share('progress', $progress);
            View::share('custom_products', $custom_products);
            View::share('menuServices', $menuServices);
            View::share('aboutStrucs', $aboutStrucs);
            View::share('about', $about);
            View::share('footer', $footer);
            View::share('blogs', $blogs);
            View::share('phone' , $phone);
            View::share('lastAddress' , $lastAddress);
            View::share('headerSections' , $headerSections);
            View::share('sec' , $sec);
            View::share('teams' , $teams);
            View::share('subheader' , $subheader);
             View::share('subheaders' , $subheaders);
            View::share('albumwhyus' ,   $albumwhyus);
             View::share('albumabout' ,   $albumabout);
            View::share('albumImages' ,   $albumImages);
            View::share('projects' ,   $projects);
            View::share('galleryImages' ,   $galleryImages);
            View::share('twoaddresses' ,   $twoaddresses);
            View::share('sliders' , $sliders);
            View::share('introslider' , $introslider);
            View::share('video' , $video);
            View::share('aboutvideos' , $aboutvideos);
            View::share('teamvideos' , $teamvideos);
            View::share('testvideos' , $testvideos);
            View::share('faqvideos' , $faqvideos);




        });
    }
}
