<?php

namespace App\Http\Controllers;

use DB;
use File;
use Image;
use App\Models\GalleryVideo;
use App\Models\About;
use App\Models\Faq;
use App\Models\Testimonial;
use App\Models\Team;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class GalleryVideoController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:galleryVideo']);
    }


    public function index(){
         $teams = Team::all();
        $galleryVideos = GalleryVideo::orderBy('order','asc')->get();
        return view('admin.galleryVideos.galleryVideos',compact('galleryVideos','teams'));
    }

    public function create(){
        return view('admin.galleryVideos.addGalleryVideo');
    }


    public function store(Request $request){
        $add = new GalleryVideo();
        $add->video_type = $request->video_type;
         $add->section_type = $request->section_type;
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->order = $request->order;
        $add->status = $request->status;
         $add->row_id = $request->row_id;
         if ($request->hasFile("img")) {

            $file = $request->file("img");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/galleryImages/source/' . $fileName);
            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $add->img = $fileName;
        } 
        
        //video type
        $request->validate([
            'video_type' => 'required|in:link,file',
            ]);
            
        if($request->video_type=='link'){
            $add->youtube_link = $this->getYoutubeEmbedUrl($request->youtube_link);    
            }
            //upload video
        elseif ($request->video_type == 'file')
        {
           $request->validate([
            'video_upload' => 'required|mimes:mp4', // 10MB maximum size
        ]);
         if ($request->hasFile('video_upload')) 
         {
        $path=base_path('uploads/videos/source');
         if (!file_exists($path)) 
         {
                mkdir($path, 0777, true);
         }
         
        $fileName = $request->file('video_upload')->getClientOriginalName();
    
        $request->file('video_upload')->move($path, $fileName);
      
        $add->video_upload =$fileName;
         }
         else {
            return redirect()->back()->withErrors(['video_upload' => 'Video file not uploaded']);
        }
       }
        $add->save();

        return redirect('admin/gallery-videos')->with('success',trans('home.your_item_added_successfully'));
    }

    public function edit($id){
        $galleryVideo=GalleryVideo::find($id);
        if($galleryVideo){
            return view('admin.galleryVideos.editGalleryVideo',compact('galleryVideo'));
        }else{
            abort('404');
        }
    }

    public function update(Request $request,$id){
        $add = GalleryVideo::find($id);
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->video_type = $request->video_type;
          $add->section_type = $request->section_type;
        $add->order = $request->order;
        $add->status = $request->status;
        $add->row_id = $request->row_id;
        if ($request->hasFile("img")) {

            $file = $request->file("img");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/galleryImages/source/';
            if ($add->img != null) {
                file_exists($img_path.$add->img) ? unlink($img_path .$add->img):'';

            }
           // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/galleryImages/source/' . $fileName);
              //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $add->img = $fileName;
        }
         //video type
        $request->validate([
            'video_type' => 'required|in:link,file',
            ]);
            
        if($request->video_type == 'link' && $request->youtube_link){
            $add->youtube_link = $this->getYoutubeEmbedUrl($request->youtube_link); 
        if ($add->video_upload) {
             
            unlink(base_path('uploads/videos/source/'.$add->video_upload));
        }
        $add->video_upload = null;
        }
        elseif ($request->video_type == 'file' && $request->hasFile('video_upload')){
           $request->validate([
            'video_upload' => 'required|mimes:mp4', 
        ]);
         
        $path=base_path('uploads/videos/source/');
         
         
        $fileName = $request->file('video_upload')->getClientOriginalName();
    
        $request->file('video_upload')->move($path, $fileName);
      
        $add->video_upload =$fileName;
        
         if ($add->youtube_link) {
            $add->youtube_link = null;
         }
        }
        $add->save();
        $videos = GalleryVideo::all();
        foreach ($videos as $video) {
        $modules = [
            'about-us' => About::class,
            'teams' => Team::class,
            'faq' => Faq::class,
            'testimonials' => Testimonial::class,
        ];
        }
        foreach ($modules as $type => $model) {
            if ($video->section_type !== $type) {
            $model::where('video_id', $id)->update(['video_id' => null]);
            }
        }
        
        return redirect('admin/gallery-videos')->with('success',trans('home.your_item_updated_successfully'));
    }

    public function reorderVideos(Request $request){
        $request->validate([
            'ids'   => 'required|array',
            'ids.*' => 'integer',
        ]);

        foreach ($request->ids as $index => $id) {
            GalleryVideo::where('id', $id)->update(['order' => $index + 1]);
        }

        $positions = GalleryVideo::pluck('order', 'id');

        return response(compact('positions'), Response::HTTP_OK);

    }


    function getYoutubeEmbedUrl($url){
         $shortUrlRegex = '/youtu.be\/([a-zA-Z0-9_-]+)\??/i';
         $longUrlRegex = '/youtube.com\/((?:embed)|(?:watch))((?:\?v\=)|(?:\/))([a-zA-Z0-9_-]+)/i';

        if (preg_match($longUrlRegex, $url, $matches)) {
            $youtube_id = $matches[count($matches) - 1];
        }

        if (preg_match($shortUrlRegex, $url, $matches)) {
            $youtube_id = $matches[count($matches) - 1];
        }
        return 'https://www.youtube.com/embed/' . $youtube_id ;
    }


    public function destroy($ids){
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $galleryVideo = GalleryVideo::findOrFail($id);
            $galleryVideo->delete();
        }
    }

}
