<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_project')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<style>
    img {
        display:block !important;
    }
    .dz-hidden-input{
        position: absolute !important;
        top: 0px !important;
        left: 250px !important;
    }

</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.projects')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/projects')); ?>"><?php echo e(trans('home.projects')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_project')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <?php if(session()->has('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session()->pull('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>    

    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/projects/'.$project->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

            
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_project')); ?></h6>
                            <hr>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e($project->name_en); ?>" required>
                            </div>

                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>"value="<?php echo e($project->name_ar); ?>" >
                            </div>

                            <div class="form-group col-md-1">
                                <label class=""><?php echo e(trans('home.price')); ?></label>
                                <input class="form-control" name="price" type="number" min="0" placeholder="<?php echo e(trans('home.price')); ?>"value="<?php echo e($project->price); ?>" >
                            </div>

                            <div class="col-md-3">
                                <label><?php echo e(trans('home.main_image')); ?></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-2">
                                <label for="alt_img"> <?php echo e(trans('home.alt_img')); ?></label>
                                <input class="form-control" name="img_alt" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>" value="<?php echo e($project->alt_img); ?>">
                            </div>

                            <?php if($project->image): ?>
                                <div class="col-md-12">
                                    <img src="<?php echo e(url('\uploads\projects\resize200')); ?>\<?php echo e($project->image); ?>" width="150">
                                    <br>
                                </div>
                            <?php endif; ?>

                            <div class="form-group col-md-6">
                                <label for="text_en"> <?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>"><?php echo e($project->text_en); ?></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="text_ar"> <?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>"><?php echo e($project->text_ar); ?></textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <hr>
                                <label for="images"><?php echo e(trans('home.project_images')); ?></label>
                                    <div class="dropzone col-md-12 upload_images">
                                </div>
                            </div>

                            <?php if($project->images()): ?>
                                <div class="col-md-12">
                                    <div id="" class="row mb-0">
                                        <?php $__currentLoopData = $project->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-xs-6 col-sm-2 col-md-2 col-xl-2 mb-2 pl-sm-2 pr-sm-2" data-responsive="<?php echo e(url('uploads/projects/source/'.$image->image)); ?>" data-src="<?php echo e(url('uploads/projects/source/'.$image->image)); ?>" data-sub-html="<h4> <?php echo e(trans('home.image')); ?> <?php echo e($key+1); ?></h4>">
                                                <a href="javascript:;">
                                                    <img class="img-responsive" src="<?php echo e(url('uploads/projects/source/'.$image->image)); ?>" width="150px" height="150px">
                                                </a>
                                                <div>
                                                    <br>
                                                    <a href='#' data-image='<?php echo e($image->id); ?>' class='delete_img_btn btn btn-danger' ><?php echo e(trans('home.delete')); ?></a>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-12">
                                <br>
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="ckbox">
                                    <input name="status" value="1" <?php echo e(($project->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class="ckbox">
                                    <input name="status" value="1" <?php echo e(($project->recommended == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.recommended')); ?></span>
                                </label>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_category')); ?>  <span class="badge badge-warning"><?php echo e(trans('home.changing category will change specifications values')); ?></span></h6>
                            <hr>
                        </div>

                        <div class="col-md-12">
                            <div class="row">
                                <div class="form-group col-md-12">
                                <button type="button" class="btn" style="position: absolute; top: -70px; right: -35px;" data-toggle="modal" data-target="#Modal1"><i class="fas fa-edit" color="black"></i></button>
                                    <select class="form-control select2" disabled >
                                        <option value="<?php echo e($project->category_id); ?>"><?php echo e((app()->getLocale()=='en')? $project->category->name_en:$project->category->name_ar); ?></option>
                                    </select>
                                </div>
                            </div>    
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

          <!-- Row-->
          <div class="col-lg-6 col-md-6">
            <div class="card custom-card">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">Attributes Values</h6>
                        <hr>
                    </div>

                    <?php $__currentLoopData = $project->projectAttribute(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-group col-md-12">
                        <label for="helperText"><?php echo e($Attribute->{'name_'.$lang}); ?></label>
                        <select class="form-control select2" name="attributevalue[<?php echo e($Attribute->id); ?>][]" multiple>
                            <?php $__currentLoopData = $attributes->AttributeValues($Attribute->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributeValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($attributeValue->id); ?>" <?php echo e(in_array($attributeValue->id, $projectAttributeValueIds) ? 'selected' : ''); ?>>
                                    <?php echo e($attributeValue->{'value_'.$lang}); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <br>
                        <input type="checkbox" id="checkbox">  <?php echo e(trans('home.selectall')); ?>

                    </div>    
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>     
                </div>
            </div>
        </div>
        <!-- End Row -->

       
        

        
        
        <div class="col-md-12">

            <hr>
            
            <div class="field_wrapper">
                <h5><?php echo e(trans('home.faq')); ?></h5>
                <div class="row">
                    <?php if(count($questions) > 0): ?>
                        <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-group col-md-12"> 
                                <label for="question"><?php echo e(trans('home.question')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" readonly value="<?php echo e($question->question); ?>">
                            </div>

                            <div class="form-group col-md-10">
                                <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" readonly><?php echo e($question->answer); ?></textarea>
                            </div>

                            <div class="form-group col-md-2">
                                <button type="button" style="margin-top: 28px;" class="btn" data-toggle="modal" data-target="#iconForm_<?php echo e($key); ?>"><i class="fas fa-edit"></i></button>
                                <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="<?php echo e($question->id); ?>" id="type-error"><i class="fas fa-trash-alt"></i></button>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                    <?php else: ?>
                        <div class="form-group col-md-12"> 
                            <label for="question"><?php echo e(trans('home.question')); ?></label>
                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]">
                        </div>

                        <div class="form-group col-md-12">
                            <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                            <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea>
                        </div> 
                    <?php endif; ?>
                </div>  
            </div>       
            <a href="javascript:void(0);" class="add_button btn" title="Add field"><i class="fas fa-plus-square"></i></a>
        </div>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">    
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/projects')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    <?php echo Form::close(); ?>


                             <!-- Modal -->
                             <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <div class="modal fade text-left" id="iconForm_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
                                 <div class="modal-dialog" role="document">
                                     <div class="modal-content">
                                         <div class="modal-header">
                                             <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_faq')); ?></h3>
                                             <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                 <span aria-hidden="true">&times;</span>
                                             </button>
                                         </div>
                                         <form action="<?php echo e(route('updateFaq')); ?>" method="post">
                                             <?php echo csrf_field(); ?>
                                             <div class="modal-body">
                                                 <div class="row">
                                                     <div class="form-group col-md-12"> 
                                                         <label for="question"><?php echo e(trans('home.question')); ?></label>
                                                         <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question" value="<?php echo e($question->question); ?>">
                                                     </div>
 
                                                     <div class="form-group col-md-12">
                                                         <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                         <textarea type="text"  class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer" ><?php echo e($question->answer); ?></textarea>
                                                     </div> 
 
                                                     <input type="hidden" name="faq_id" value="<?php echo e($question->id); ?>"/>
 
                                                     <div class="form-group col-md-12">
                                                         <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?> </button>
                                                     </div>
                                                 </div>                             
                                             </div>
                                         </form>
                                     </div>
                                 </div>
                             </div>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!-- modal1 -->
    <div class="modal fade text-left" id="Modal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_category')); ?></h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(url('admin/projects/changeCategory/'.$project->id)); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            
                            <div class="form-group col-md-12">
                                <select class="form-control select2" name="category_id" id="category" required>
                                    <option></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e((app()->getLocale()=='en')? $category->name_en:$category->name_ar); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                </select>
                            </div>  

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"> <?php echo e(trans('home.save')); ?> </button>
                            </div>
                        </div>                             
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>
    
    <script type="text/javascript">

        var token = "<?php echo e(csrf_token()); ?>";
        //Dropzone.autoDiscover = true;
        Dropzone.autoDiscover = false;

        $("div.upload_images").dropzone({
            
            addRemoveLinks: true,
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            url: "<?php echo e(URL::to('admin/projects/uploadImages')); ?>",

            init: function() {
                this.on("sending", function(file, xhr, formData) {
                    formData.append("projectId", <?php echo e($project->id); ?>);
                });
            },
            
            params: {
                _token: token,
                type: 'product_image',
            },

            removedfile: function(file) {

                var fileName = file.name; 
                $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
                    $.ajax({
                    type: 'POST',
                    url: "<?php echo e(URL::to('admin/projects/removeUploadImages')); ?>",
                    data: {type:'project_image',name: fileName,request: 'delete'},
                    sucess: function(data){
                        console.log('success: ' + data);
                    }
                });
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }

        });
        
    
        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 3, // MB
            accept: function(file, done) {

            },
        };
        
        
        $('.delete_img_btn').on('click',function(){
            var image = $(this).data('image');
            var projectId=<?php echo e($project->id); ?>;
            var btn = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:" <?php echo e(url('admin/projects/deleteImege')); ?>",
                method:'POST',
                data:{image:image , projectId:projectId },
                success:function(data)
                {
                    location.href = "<?php echo e(route('projects.edit',$project->id)); ?>";
                }
            });
        });

        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><hr><div class="form-group col-md-12"><label for="question"><?php echo e(trans('home.question')); ?></label><input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]"></div>';
            fieldHTML +='<div class="form-group col-md-11"><label for="answer"><?php echo e(trans('home.answer')); ?></label><textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea></div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });

        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo e(route('removeFaq')); ?>",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
            
        });

    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\opera\resources\views/admin/projects/editProject.blade.php ENDPATH**/ ?>