<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_service')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<style>
    img {
        display:block !important;
    }
    .dz-hidden-input{
        position: absolute !important;
        top: 0px !important;
        left: 250px !important;
    }

</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.services')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/services')); ?>"><?php echo e(trans('home.services')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_service')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.edit_service')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/services/'.$service->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-2">
                                    <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>" name="name_en" value="<?php echo e($service->name_en); ?>" required>
                                </div>

                                <div class="form-group col-md-2">
                                    <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>" name="name_ar" value="<?php echo e($service->name_ar); ?>">
                                </div>

                                <div class="form-group col-md-4">
                                    <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link" value="<?php echo e($service->youtube_link); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.parent')); ?></label>
                                    <select class="form-control select2" name="parent_id" required>
                                        <option value="0" <?php echo e(($service->parent_id == 0)?'selected':''); ?>><?php echo e(trans('home.no_parent')); ?></option>
                                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($serv->id); ?>"  <?php echo e(($serv->id ==$service->parent_id)?'selected':''); ?>><?php echo e((app()->getLocale() == 'en')?$serv->name_en:$serv->name_ar); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-1">
                                    <label for="order"><?php echo e(trans('home.order')); ?></label>
                                    <input type="number" min="0"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($service->order); ?>">
                                </div>
                                
                                <div class="col-md-4">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="img">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label for="alt_img"> <?php echo e(trans('home.alt_img')); ?></label>
                                    <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>" value="<?php echo e($service->alt_img); ?>">
                                </div>

                                <div class="col-md-6">
                                    <label><?php echo e(trans('home.icon')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="icon">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_icon')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="row">
                                        <?php if($service->img): ?>
                                            <div class="col-md-6">
                                                <img src="<?php echo e(url('\uploads\services\resize200')); ?>\<?php echo e($service->img); ?>" width="200" height="150">
                                            </div>
                                        <?php endif; ?>

                                        <?php if($service->icon): ?>
                                            <div class="col-md-6">
                                                <img src="<?php echo e(url('\uploads\services\resize200')); ?>\<?php echo e($service->icon); ?>" width="200" height="150">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>


                                <div class="form-group col-md-6">
                                    <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                    <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ><?php echo $service->text_en; ?></textarea>
                                </div>

                                <div class="form-group col-md-6 "> 
                                    <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                    <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ><?php echo $service->text_ar; ?></textarea>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($service->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>
                                
                                <div class="form-group col-md-4">
                                    <label class="ckbox">
                                        <input name="home" value="1" <?php echo e(($service->home == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.home')); ?></span>
                                    </label>
                                </div>


                                <div class="form-group col-md-4">
                                    <label class="ckbox">
                                        <input name="menu" value="1" <?php echo e(($service->menu == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.menu')); ?></span>
                                    </label>
                                </div>


                                <div class="form-group col-md-12">
                                    <hr>
                                    <label for="images"><?php echo e(trans('home.service_images')); ?></label>
                                        <div class="dropzone col-md-12 upload_images">
                                    </div>
                                </div>
                                
                                <?php if($service->images()): ?>
                                    <div class="col-md-12">
                                        <div id="lightgallery" class="row mb-0">
                                            <?php $__currentLoopData = $service->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-xs-6 col-sm-2 col-md-2 col-xl-2 mb-2 pl-sm-2 pr-sm-2" data-responsive="<?php echo e(url('uploads/services/source/'.$image->image)); ?>" data-src="<?php echo e(url('uploads/services/source/'.$image->image)); ?>" data-sub-html="<h4> <?php echo e(trans('home.image')); ?> <?php echo e($key+1); ?></h4>">
                                                    <a href="">
                                                        <img class="img-responsive" src="<?php echo e(url('uploads/services/source/'.$image->image)); ?>">
                                                    </a>
                                                    <div>
                                                        <a href='#' data-image='<?php echo e($image->id); ?>' class='delete_img_btn' ><?php echo e(trans('home.delete')); ?></a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="col-12">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en" value="<?php echo e($service->link_en); ?>">
                                        </div>
                                
                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                            <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($service->meta_title_en); ?></textarea>
                                        </div>
                                        
                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                            <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($service->meta_desc_en); ?></textarea>
                                        </div>
                                        
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar" value="<?php echo e($service->link_ar); ?>">
                                        </div>
                                        
                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                            <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($service->meta_title_ar); ?></textarea>
                                        </div>
                                        
                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                            <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($service->meta_desc_ar); ?></textarea>
                                        </div>
                                        
                                        <div class="form-group col-md-12">
                                            <label class="ckbox">
                                                <input name="meta_robots" value="1" <?php echo e(($service->meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.meta_robots')); ?> (index)</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <hr>
                                    
                                    <div class="field_wrapper">
                                        <h5><?php echo e(trans('home.faq')); ?></h5>
                                        <div class="row">
                                            <?php if(count($questions) > 0): ?>
                                                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-group col-md-12"> 
                                                        <label for="question"><?php echo e(trans('home.question')); ?></label>
                                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" readonly value="<?php echo e($question->question); ?>">
                                                    </div>
            
                                                    <div class="form-group col-md-10">
                                                        <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                        <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" readonly><?php echo e($question->answer); ?></textarea>
                                                    </div>
    
                                                    <div class="form-group col-md-2">
                                                        <button type="button" style="margin-top: 28px;" class="btn" data-toggle="modal" data-target="#iconForm_<?php echo e($key); ?>"><i class="fas fa-edit"></i></button>
                                                        <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="<?php echo e($question->id); ?>" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                            <?php else: ?>
                                                <div class="form-group col-md-12"> 
                                                    <label for="question"><?php echo e(trans('home.question')); ?></label>
                                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]">
                                                </div>
        
                                                <div class="form-group col-md-12">
                                                    <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                    <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea>
                                                </div> 
                                            <?php endif; ?>
                                        </div>  
                                    </div>       
                                    <a href="javascript:void(0);" class="add_button btn" title="Add field"><i class="fas fa-plus-square"></i></a>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="image-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/services')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                        
                         <!-- Modal -->
                        <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="modal fade text-left" id="iconForm_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_faq')); ?></h3>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="<?php echo e(route('updateFaq')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="form-group col-md-12"> 
                                                        <label for="question"><?php echo e(trans('home.question')); ?></label>
                                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question" value="<?php echo e($question->question); ?>">
                                                    </div>

                                                    <div class="form-group col-md-12">
                                                        <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                        <textarea type="text"  class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer" ><?php echo e($question->answer); ?></textarea>
                                                    </div> 

                                                    <input type="hidden" name="faq_id" value="<?php echo e($question->id); ?>"/>

                                                    <div class="form-group col-md-12">
                                                        <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?> </button>
                                                    </div>
                                                </div>                             
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>
    
    <script type="text/javascript">

        var token = "<?php echo e(csrf_token()); ?>";
        //Dropzone.autoDiscover = true;
        Dropzone.autoDiscover = false;

        $("div.upload_images").dropzone({
            
            addRemoveLinks: true,
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            url: "<?php echo e(URL::to('admin/services/uploadImages')); ?>",

            init: function() {
                this.on("sending", function(file, xhr, formData) {
                    formData.append("serviceId", <?php echo e($service->id); ?>);
                });
            },
            
            params: {
                _token: token,
                type: 'product_image',
            },

            removedfile: function(file) {

                var fileName = file.name; 
                $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
                    $.ajax({
                    type: 'POST',
                    url: "<?php echo e(URL::to('admin/services/removeUploadImages')); ?>",
                    data: {type:'service_image',name: fileName,request: 'delete'},
                    sucess: function(data){
                        console.log('success: ' + data);
                    }
                });
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }

        });
        
    
        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 3, // MB
            accept: function(file, done) {

            },
        };
        
        $('.delete_img_btn').on('click',function(){
            var image = $(this).data('image');
            var serviceId=<?php echo e($service->id); ?>;
            var btn = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:" <?php echo e(url('admin/services/deleteImege')); ?>",
                method:'POST',
                data:{image:image , serviceId:serviceId },
                success:function(data)
                {
                    location.href = "<?php echo e(route('services.edit',$service->id)); ?>";
                }
            });
        });
        
        
        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><hr><div class="form-group col-md-12"><label for="question"><?php echo e(trans('home.question')); ?></label><input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]"></div>';
            fieldHTML +='<div class="form-group col-md-11"><label for="answer"><?php echo e(trans('home.answer')); ?></label><textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea></div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
        
        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo e(route('removeFaq')); ?>",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
            
        });

    </script>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/opera/resources/views/admin/services/editService.blade.php ENDPATH**/ ?>