<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>">

<head>
    <meta charset="utf-8">


    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta property="og:title" content="" />
    <meta property="og:type" content="" />
    <meta property="og:url" content="" />
    <meta property="og:image" content="" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <?php echo $__env->make('layouts.partials.hreflang', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon"
        href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>" />
    <!-- Template CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('main.css?v=5.6')); ?>" />
    <!--<link rel="stylesheet" href="assets/css/rtl.css" />-->

    <?php echo $__env->yieldContent('style'); ?>
    <!-- Google Tag Manager -->
    <?php echo $setting->publish_gtm_script ? html_entity_decode($setting->gtm_script) : ''; ?>

    <!-- End Google Tag Manager -->
</head>

<body>

   <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <?php echo $__env->make('layouts.partials.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <main class="main">
      <?php echo $__env->yieldContent('content'); ?>
   </main>

   
<?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

 <!-- Preloader Start -->
 <div id="preloader-active">
   <div class="preloader d-flex align-items-center justify-content-center">
     <div class="preloader-inner position-relative">
       <div class="loadingio-spinner-ripple-nq4q5u6dq7r">
           <div class="ldio-x2uulkbinbj">
               <div></div>
               <div></div>
           </div>
       </div>
     </div>
   </div>
 </div>

 <ul id="wrapper" class="" style="transform: translate(15%, 100%);">
   <li class="Icon call">
       <!--<span class="tooltip">Call</span>-->
       <a href="tel:+2<?php echo e($setting->mobile); ?>"><span><i class="fa fa-phone"></i></span></a>
   </li>
   <li class="Icon whatsapp">
       <!--<span class="tooltip">whatsapp</span>-->
       <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target="_blank"><span><i class="fab fa-whatsapp"></i></span></a>
   </li>

</ul>


    <script src="<?php echo e(Helper::jsFilesPath('vendor/modernizr-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-migrate-3.3.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('vendor/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/slick.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.syotimer.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/waypoints.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/perfect-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/select2.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/counterup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.countdown.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/images-loaded.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/isotope.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/scrollup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper.min.js')); ?>"></script>
  
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.vticker-min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.theia.sticky.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.elevatezoom.js')); ?>"></script>
    <!-- Template  JS -->
    <script src="<?php echo e(Helper::jsFilesPath('main.js?v=5.6')); ?>"></script>


    <?php echo $__env->yieldContent('script'); ?>

    <!-- Google Tag Manager -->
    <?php echo $setting->publish_gtm_script ? html_entity_decode($setting->gtm_noscript) : ''; ?>

    <!-- End Google Tag Manager -->
</body>

</html>
<?php /**PATH C:\OSPanel\domains\opera\resources\views/layouts/app.blade.php ENDPATH**/ ?>