

<?php $__env->startSection('content'); ?>

<section class="page-header">

    <div class="page-header__bg" style="background-image: url(<?php echo e(url('uploads/settings/source/' . $configration->Branche_banner)); ?>);"></div>

        <div class="container">

            <ul class="thm-breadcrumb list-unstyled">

                <li><a href="<?php echo e(laravelLocalization::LocalizeUrl('/')); ?>"><?php echo e(trans('home.home')); ?></a></li>

                <li>/</li>

                <li><span><?php echo e(trans('home.Branches')); ?></span></li>

            </ul>

            <h2><?php echo e(trans('home.Branches')); ?></h2>

        </div>

</section>

<!--End page-header-->

<section class="contact-section pt-100 pb-100">

            <div class="container">

             

            <div class="row">

                      <div class="col-md-12 text-center pb-50">

                        <p class="content-box"><?php echo $configration->feature_section_desc; ?></p>

                    </div>

                    <div class="col-md-12">

                        <div class="top-select pb-50">

                            <div class="row">

                                <div class="form-group col-md-6 m-auto">

                                    <select class="form-select region select2 filter" name="region_id">

                                           <option><?php echo e(trans('home.regions')); ?></option>

                                           <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                  <option value="<?php echo e($region->id); ?>"  data-gis="<?php echo e($region->gis); ?>"><?php echo e($region->{'name_'.$lang}); ?></option>

                                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                         

                                         

                                    </select>

                                </div>

                               

                            </div>     

                        </div>

                    </div>

             </div>

            <div class="row">

                        <div class="row" id="gis-branches">

                            <!-- GIS branches will be dynamically added here -->

                             <?php $__currentLoopData = $firstRegin->areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                  

                                     

                                          <div class="col-md-4">

                                              <div class="branche branche-page">

                                                  <a href="<?php echo e($area->map_url); ?>" class="btn btn-dark btn-rounded" target="_blank">View Location</a>

                                                 

                                                <h5 class="mb-3"><i class="pe-2 fa fa-map-marker-alt"></i><?php echo e($area->{'name_'.$lang}); ?> </h5>

                                                    <span class="mb-1"><a class="text-dark" href="tel:+2<?php echo e($area->mobile); ?>"><i class="pe-1 text-muted fa fa-phone"></i> <?php echo e($area->mobile); ?></a></span>  <br>

                                                    <span class="mb-1"><a class="text-dark" href="tel:+2<?php echo e($area->mobile2); ?>"><i class="pe-1 text-muted fa fa-phone"></i><?php echo e($area->mobile2); ?></a></span> <br>

                                                    <span class="mb-1"><a class="text-dark" href="tel:+2<?php echo e($area->fax); ?>"><i class="pe-1 text-muted fa fa-phone"></i><?php echo e($area->fax); ?></a></span> <br>

                                                    <span class="mb-1"><a class="text-dark" href="mailto:<?php echo e($area->email); ?>"><i class="pe-1 text-muted fa fa-envelope"></i><?php echo e($area->email); ?></a></span> <br>

                                              </div>

                                          </div>

                                       

                                  

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>

                    </div>

            

            </div>

           

        </section>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>



<script>

    $(document).ready(function() {

        // Handle region selection change

        $('.region').change(function() {

            var region_id = $(this).val();

           

            // Update the GIS branches

            $.ajaxSetup({

                        headers: {

                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                        }

                    });



            $.ajax({

                url: "<?php echo e(LaravelLocalization::localizeUrl('get-Branches')); ?>",

                method: 'POST',

                data:{

                    region_id:region_id

                },

                success: function(data) {

                    var lang = "<?php echo e(\LaravelLocalization::getCurrentLocale()); ?>";

                    // Clear previous branches

                     $('#gis-branches').empty();



                    // Add new branches

                    $.each(data['RegionAreas'], function(index, branch) {

                        var branchHtml = '<div class="col-md-4">' +

                            '<div class="branche branche-page">';

                        if (branch.map_url) {

                            branchHtml += '<a href="' + branch.map_url + '" class="btn btn-dark btn-rounded" target="_blank">View Location</a>';

                        }

                        branchHtml += '<h5 class="mb-3"><i class="pe-2 fa fa-map-marker-alt"></i>' + branch['name_' + lang] + '</h5>' +

                            '<p>' + branch['address_' + lang] + '</p>' +

                            '<span class="mb-1"><a class="text-dark" href="tel:' + branch.mobile + '"><i class="pe-1 text-muted fa fa-phone"></i>' + branch.mobile + '</a></span> <br>' +

                            '<span class="mb-1"><a class="text-dark" href="tel:' + branch.mobile2 + '"><i class="pe-1 text-muted fa fa-phone"></i>' + branch.mobile2 + '</a></span> <br>' +

                            '<span class="mb-1"><a class="text-dark" href="tel:' + branch.fax + '"><i class="pe-1 text-muted fa fa-phone"></i>' + branch.fax + '</a></span> <br>' +

                            '<span class="mb-1"><a class="text-dark" href="mailto:' + branch.email + '"><i class="pe-1 text-muted fa fa-envelope"></i>' + branch.email + '</a></span> <br>' +

                            '</div>' +

                            '</div>';

                            

                        $('#gis-branches').append(branchHtml);

                    });

                },

                error: function(xhr, status, error) {

                    

                }

            });

        });

    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/operaeg2/public_html/resources/views/website/Branches.blade.php ENDPATH**/ ?>