<?php $__env->startSection('meta'); ?>
    <?php echo $metatags ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header Banner -->

    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url(<?php echo e(url('uploads/settings/source/' . $configration->product_banner)); ?>);"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="<?php echo e(LaravelLocalization::LocalizeUrl('/')); ?>"><?php echo e(trans('home.home')); ?></a></li>
                <li>/</li>
                <li><span> <?php echo e(trans('home.products')); ?></span></li>
            </ul>
            <h2> <?php echo e(trans('home.products')); ?></h2>
        </div>
    </section>





    <section class="section-padding py-100">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="sidebar-widget widget-category-2 mb-30">
                        <h5 class="section-title style-1 mb-30"><?php echo e(trans('home.categories')); ?></h5>
                        <ul>
                            <?php $__currentLoopData = $mainCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mainCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href='<?php echo e(LaravelLocalization::localizeUrl('category/' . $mainCategory->{'link_' . $lang} . '/products')); ?>'><?php echo e($mainCategory->{'name_'.$lang}); ?></a><span class="count"><?php echo e($mainCategory->projects()->count()); ?></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>
                    <!-- Fillter By Price -->
                
                    <Form action="<?php echo e(laravelLocalization::LocalizeUrl('products')); ?>" method="GET"> 
                        <div class="sidebar-widget price_range range mb-30">
                            <h5 class="section-title style-1 mb-30">Fill by Products</h5>
                            <div class="list-group">
                                <div class="list-group-item mb-10 mt-10">
                                    <?php $__currentLoopData = $categoryAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $categoryAttribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label class="fw-900"><?php echo e($categoryAttribute->{'name_' . $lang}); ?></label>
                                        <?php $__currentLoopData = $categoryAttribute->values(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $categoryAttributeValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="custome-checkbox">
                                                <div>
                                                    <input class="form-check-input" type="checkbox"
                                                        name="categoryAttributeValue[<?php echo e($categoryAttribute->id); ?>][]"
                                                        id="exampleCheckbox<?php echo e($key + 1 .'-'.$index+1); ?>"
                                                        value="<?php echo e($categoryAttributeValue->id); ?>"
                                                        <?php echo e(in_array($categoryAttributeValue->id, request()->input("categoryAttributeValue.{$categoryAttribute->id}", [])) ? 'checked' : ''); ?> />
                                                    <label class="form-check-label"
                                                        for="exampleCheckbox<?php echo e($key + 1 .'-'.$index+1); ?>"><span><?php echo e($categoryAttributeValue->{'value_' . $lang}); ?></span></label>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <button class='btn btn-sm btn-default' type="submit">
                                <i class="fi-rs-filter mr-5"></i> Fillter
                            </button>
                        </div>
                </Form>
                    <!-- Product sidebar Widget -->

                </div>
           
                <div class="col-md-9">
                    <?php if(count($projects)>0): ?>
                    <div class="infinite-scroll">
                        <div class="row">
                            <!--start product Wrap-->
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="product-cart-wrap">
                                        <div class="product-img-action-wrap">
                                            <div class="product-img product-img-zoom">
                                                <a
                                                    href="<?php echo e(laravelLocalization::LocalizeUrl('product/' . $product->{'link_' . $lang})); ?>">
                                                    <img class="default-img"
                                                        src="<?php echo e(Helper::uploadedImagesPath('projects', $product->image)); ?>"
                                                        alt="" />
                                                </a>
                                            </div>
                                        </div>
                                        <div class="product-content-wrap">

                                            <h2><a
                                                    href="<?php echo e(laravelLocalization::LocalizeUrl('product/' . $product->{'link_' . $lang})); ?>"><?php echo e($product->{'name_' . $lang}); ?></a>
                                            </h2>

                                            <div class="sold mt-15 mb-15">

                                                <p class="text-heading"> <?php echo Str::limit($product->{'text_' . $lang}, 5, '...'); ?></p>
                                            </div>

                                            <a href="<?php echo e(laravelLocalization::LocalizeUrl('product/' . $product->{'link_' . $lang})); ?>"
                                                class="btn w-100 hover-up"><i
                                                    class="fi-rs-eye mr-5"></i><?php echo e(trans('home.read_more')); ?></a>
                                        </div>
                                    </div>
                                </div>
                                <!--End product Wrap-->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($projects->links()); ?>

                        </div>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-warning text-center mt-5" role="alert">
                        No Products found
                   </div>
                <?php endif; ?>
                </div>

              
            </div>
        </div>
    </section>

    <!--End Products Section ======================-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <!-- js for scroll pagination -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
        $(document).ready(function() {
            $('nav[aria-label="Pagination Navigation"]').hide();
            // Initialize jscroll
            var jscrollInstance = $('.infinite-scroll').jscroll({
                autoTrigger: true,
                loadingMsg: '<div class="loading"><b>Loading...</b></div>',
                padding: 0,
                nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
                contentSelector: 'div.infinite-scroll',
                callback: function() {
                    // Remove pagination navigation after appending new content
                    $('nav[aria-label="Pagination Navigation"]').remove();

                    // Check if there are more pages
                    if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                        // No more pages, destroy jscroll
                        jscrollInstance.destroy();
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/operaeg2/public_html/resources/views/website/products.blade.php ENDPATH**/ ?>