@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp

    @php echo $schema @endphp
@endsection

@section('content')
    <!-- Header Banner -->
    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/settings/source/' . $configration->contact_us_banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span>{{ trans('home.contact-us') }}</span></li>
            </ul>
            <h2>{{ trans('home.contact-us') }}</h2>
        </div>
    </section>
    <!-- End Header Banner -->
    <section class="contact-box-section pt-100 pb-100">
        <div class="container">
            <div class="row g-lg-5 g-3">
                <div class="col-lg-6">
                    <div class="left-sidebar-box">
                        <div class="row">

                            <div class="col-xl-12">
                                <div class="contact-title">
                                    <h3>{{ trans('home.get_in_touch') }}</h3>
                                </div>

                                <div class="contact-detail">
                                    <div class="row g-4">
                                        <div class="col-xxl-6 col-lg-12 col-sm-6">
                                            <div class="contact-detail-box">
                                                <div class="contact-icon">
                                                    <i class="fa-solid fa-phone"></i>
                                                </div>
                                                <div class="contact-detail-title">
                                                    <h4>{{ trans('home.phone') }}</h4>
                                                </div>

                                                <div class="contact-detail-contain">
                                                    <p>{{ $setting->mobile }}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-xxl-6 col-lg-12 col-sm-6">
                                            <div class="contact-detail-box">
                                                <div class="contact-icon">
                                                    <i class="fa-solid fa-envelope"></i>
                                                </div>
                                                <div class="contact-detail-title">
                                                    <h4>{{ trans('home.email') }}</h4>
                                                </div>

                                                <div class="contact-detail-contain">
                                                    <p>{{ $setting->email }}</p>
                                                </div>
                                            </div>
                                        </div>
                                        {{--
                                        @foreach ($addresses as $address)
                                            <div class="col-xxl-6 col-lg-12 col-sm-6">
                                                <div class="contact-detail-box">
                                                    <div class="contact-icon">
                                                        <i class="fa-solid fa-location-dot"></i>
                                                    </div>
                                                    <div class="contact-detail-title">
                                                        <h4>{{ trans('home.Main Office') }}</h4>
                                                    </div>

                                                    <div class="contact-detail-contain">
                                                        <p>{{ $address->{'address_' . $lang} }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach


--}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="title d-xxl-none d-block">
                        <h2>{{ trans('home.contact-us') }}</h2>
                    </div>
                    @if (session()->has('contact_message'))
                        <div class="messages text-success">
                            {{ session()->get('contact_message') }}
                        </div>
                    @endif
                    <form class="contact-form-style mt-30"
                        action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}" method="post">
                        @csrf
                        <div class="right-sidebar-box">
                            <div class="row">
                                <div class="col-xxl-6 col-lg-12 col-sm-6">
                                    <div class="mb-md-4 mb-3 custom-form">
                                        <label for="exampleFormControlInput"
                                            class="form-label">{{ trans('home.name') }}</label>
                                        <div class="custom-input">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ old('name') }}" placeholder="{{ trans('home.name') }}"
                                                required>
                                            @error('name')
                                                <div class="help-block with-errors">*{{ $message }}</div>
                                            @enderror
                                            <i class="fa-solid fa-user"></i>
                                        </div>
                                    </div>
                                </div>



                                <div class="col-xxl-6 col-lg-12 col-sm-6">
                                    <div class="mb-md-4 mb-3 custom-form">
                                        <label for="exampleFormControlInput2"
                                            class="form-label">{{ trans('home.email') }}</label>
                                        <div class="custom-input">
                                            <input type="text" name="email" class="form-control" id="email"
                                                value="{{ old('email') }}" placeholder="{{ trans('home.email') }}"
                                                required>
                                            @error('email')
                                                <div class="help-block with-errors">*{{ $message }}</div>
                                            @enderror
                                            <i class="fa-solid fa-envelope"></i>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-sm-6">
                                    <div class="mb-md-4 mb-3 custom-form">
                                        <label for="exampleFormControlInput3"
                                            class="form-label">{{ trans('home.phone') }}</label>
                                        <div class="custom-input">
                                            <input type="text" class="form-control" name="phone" id="phone"
                                                value="{{ old('phone') }}" placeholder="{{ trans('home.phone') }}"
                                                required>
                                            @error('phone')
                                                <div class="help-block with-errors"> *{{ $message }}</div>
                                            @enderror
                                            <i class="fa-solid fa-mobile-screen-button"></i>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="mb-md-4 mb-3 custom-form">
                                        <label for="exampleFormControlTextarea"
                                            class="form-label">{{ trans('home.message') }}</label>
                                        <div class="custom-textarea">
                                            <textarea name="message" id="message" class="form-control" rows="3" placeholder="{{ trans('home.message') }}">{{ old('message') }}</textarea>
                                            @error('message')
                                                <div class="help-block with-errors"></div>
                                            @enderror
                                            <i class="fa-solid fa-message"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button class="btn mt-sm-4 btn-2 theme-bg-color text-white mend-auto btn-2-animation ms-auto"
                                type="submit">{{ trans('home.Submit Now') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
