@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
@endsection

@section('content')
    <!-- Header Banner -->
    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/aboutStrucs/source/' . $about->banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span> {{ trans('home.blogs') }}</span></li>
            </ul>
            <h2> {{ trans('home.blogs') }}</h2>
        </div>
    </section>
    <!--End Header Banner -->

    <!-- Blog -->
    <div class="blog-seciont pb-50">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="shop-product-fillter mb-50 section-padding pb-5">
                        <div class="totall-product">
                            <h2>
                                {{ trans('home.our blogs') }}
                            </h2>
                        </div>
                    </div>
                    <div class="loop-grid">
                        <div class="row">
                            @foreach ($blogs as $blogItem)
                                <article
                                    class="col-xl-3 col-lg-4 col-md-6 text-center hover-up mb-30 wow animate__animated animate__fadeInUp"
                                    data-wow-delay="0">
                                    <div class="post-thumb">
                                        <a
                                            href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}">
                                            <img class="border-radius-15"
                                                src="{{ Helper::uploadedImagesPath('blogitems', $blogItem->image) }}"
                                                alt="" />
                                        </a>

                                    </div>
                                    <div class="entry-content-2">
                                        <h4 class="post-title mb-15">
                                            <a
                                                href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}">
                                                {{ $blogItem->{'title_' . $lang} }}</a>
                                        </h4>
                                        <p class="post-exerpt font-medium text-muted mb-30"> {!! Str::words($blogItem->{'text_' . $lang}, 30, '...') !!}</p>
                                        <div class="mb-20 entry-meta meta-2">
                                            <a class="btn btn-sm"
                                                href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}">{{ trans('home.read_more') }}<i
                                                    class="fi-rs-arrow-right ml-10"></i></a>
                                        </div>
                                    </div>
                                </article>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Blog -->
@endsection
