@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp

    @php echo $schema @endphp
@endsection

@section('content')
    <!-- Header Banner -->

    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/settings/source/' . $configration->about_us_banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span>{{ trans('home.about-us') }}</span></li>
            </ul>
            <h2>{{ trans('home.about-us') }}</h2>
        </div>
    </section>

    
    <section class="about-section section-padding pt-100">
        <div class="image-layer"></div>

        <div class="container">

            <div class="row mb-50 align-items-center">
                <div class="col-lg-6">
                    <img src="{{ Helper::uploadedImagesPath('aboutStrucs', $about->image) }}" alt="">
                </div>
                <div class="col-lg-5">
                    <h4 class="mb-20 text-muted">{{ trans('home.About Opera') }}</h4>
                    <h1 class="heading-1 mb-40">{{ $about->{'title_' . $lang} }}</h1>
                    <p class="mb-30">{!! $about->{'text_' . $lang} !!}</p>

                </div>
            </div>
        </div>

    </section>
    <!--End about -->

    <!-- Mission Section Start -->
    <section class="client-section section-padding pt-50 pb-50">
        <div class="container">
            <div class="about-us-title text-center">
                <h2 class="center pb-50">{{ trans('home.Why Choose us') }}</h2>
            </div>
            @foreach ($aboutStrucs as $aboutStruc)
                @if($loop->iteration % 2 == 1)
                <div class="row">
                    <div class="col-lg-6">
                        <div class="clint-contain">
                            <h4>{{ $aboutStruc->title }}</h4>
                            <p>

                                {!! $aboutStruc->text !!}
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <img src="{{ Helper::uploadedImagesPath('aboutStrucs', $aboutStruc->image) }}" alt="">
                    </div>
                </div>
                @else
                <div class="row">
                    <div class="col-lg-6">
                        <img src="{{ Helper::uploadedImagesPath('aboutStrucs', $aboutStruc->image) }}" alt="">
                    </div>
                    <div class="col-lg-6">
                        <div class="clint-contain">
                            <h4>{{ $aboutStruc->title }}</h4>
                            <p>

                                {!! $aboutStruc->text !!}
                            </p>
                        </div>
                    </div>
    
                </div>
                @endif
             @endforeach
        </div>
    </section>

    
    <!-- Mission Section End -->
@endsection
