<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use File;
use Image;
use Excel;
use App\Models\Certificate;
use App\Imports\CertificateImport;
class SettingController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:setting');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $settings =Setting::first();
        return view('admin.settings.setting',compact('settings'));
    }

    public function update(Request $request, $id)
    {
        $settings=Setting::first();
        $settings->default_lang = $request->default_lang;
        $settings->contact_email = $request->contact_email;
        $settings->email = $request->email;
        $settings->telphone = $request->telphone;
        $settings->mobile = $request->mobile;
        $settings->mobile2 = $request->mobile2;
        $settings->fax = $request->fax;
        $settings->facebook = $request->facebook;
        $settings->linkedin = $request->linkedin;
        $settings->instgram = $request->instgram;
        $settings->twitter = $request->twitter;
        $settings->lat = $request->lat;
        $settings->lng = $request->lng;
        $settings->map_url = $request->map_url;
        $settings->whatsapp = $request->whatsapp;
        $settings->snapchat = $request->snapchat;
        $settings->tiktok = $request->tiktok;
        $settings->youtube = $request->youtube;
        $settings->cetificates = $request->cetificates;
        $settings->exp_years = $request->exp_years;
        $settings->happy_clients = $request->happy_clients;
        $settings->projects_complete = $request->projects_complete;
        $settings->products_sale = $request->products_sale;
        $settings->gtm_script = $request->gtm_script;
        $settings->gtm_noscript = $request->gtm_noscript;
        $settings->publish_gtm_script = $request->publish_gtm_script;
        $settings->publish_contact_modal = $request->publish_contact_modal;
        $settings->save();

        return back()->with('success',trans('home.settings_updated_successfully'));
    }
    
    public function certificateExcelView(){
        $records = Certificate::get();
        return view('admin.settings.certificateExcel',compact('records'));
    }

    public function saveCertificateRecords(Request $request){
        
        $this->validate($request,[
            'excel_file' => 'required|mimes:xlsx'
        ]);
        Excel::import(new CertificateImport, $request->excel_file);
        return back()->with('success',trans('home.imported_successfully'));
    }


}
