<title><?php echo e(trans('home.blogitems')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.blogitems')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.blogitems')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/blog-items/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <a href="javascript:void(0)"><button class="copyButton btn ripple btn-info col-md-2"><i class="bx bx-copy-alt"></i> <?php echo e(trans('home.copy')); ?></button></a>
        <!-- End Page Header -->


        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table" id="datatable">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll"/></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.title_en')); ?></th>
                                <th><?php echo e(trans('home.title_ar')); ?></th>
                                <th><?php echo e(trans('home.date')); ?></th>
                                <th><?php echo e(trans('home.writer')); ?></th>
                                <th><?php echo e(trans('home.blog_preview')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th>
                                    <div class="d-block">
                                        <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light" ><?php echo e(__('home.delete')); ?></a>
                                    <div>                                 
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $blogItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($blogItem->id); ?>">
                                    <td> <input type="checkbox" name="checkbox"  class="tableChecked form-check-input" value="<?php echo e($blogItem->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('blog-items.edit', $blogItem->id)); ?>"><?php echo e($blogItem->id); ?></a></td>
                                    <td><a href="<?php echo e(route('blog-items.edit', $blogItem->id)); ?>"><?php echo e($blogItem->title_en); ?></a></td>
                                    <td><a href="<?php echo e(route('blog-items.edit', $blogItem->id)); ?>"><?php echo e($blogItem->title_ar); ?></a></td>
                                    <td><a href="<?php echo e(route('blog-items.edit', $blogItem->id)); ?>"><?php echo e($blogItem->date); ?></a></td>
                                    <td><a href="<?php echo e(route('blog-items.edit', $blogItem->id)); ?>"><?php echo e($blogItem->writers->name??'No Writer'); ?></a></td>
                                    <td><a href='<?php echo e(($lang == "en")?LaravelLocalization::localizeUrl("/blog/$blogItem->link_en"):LaravelLocalization::localizeUrl("/blog/$blogItem->link_ar")); ?>' target="_blank"><i class="fas fa-eye"></i> <?php echo e(trans('home.blog_preview')); ?></a></td>
                                    <td> 
                                        <input class="btn_active" data-id="<?php echo e($blogItem->id); ?>" type="checkbox" id="switch-<?php echo e($blogItem->id); ?>" switch="success" <?php echo e($blogItem->status == 1?'checked':''); ?> />
                                        <label for="switch-<?php echo e($blogItem->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-info waves-effect waves-light " 
                                            href="<?php echo e(route('blog-items.edit',$blogItem->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                            data-id="<?php echo e($blogItem->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).on('click', '.copyButton', function() {
            var ids = [];
            $('.tableChecked:checked').each(function(i){
                ids[i] = $(this).val();
            });
            if(ids.length === 0) //tell you if the array is empty
            {
                alert("Please Select atleast one checkbox");
            }
            else{
              
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo route('BlogItemCopy') ?>",
                    type:'POST',
                    data:{ids:ids},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }

        });
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\gamgoum\resources\views/admin/blogItems/blogItems.blade.php ENDPATH**/ ?>