<!--====== CONTACT PART START ======-->
 <section class="contact-part pt-115 pb-115">
     <div class="container">
         <!-- Contact Info -->
         <div class="row">
        <div class="row align-items-center mb-5">
            <div class="col-lg-6 col-md-8 col-sm-7">
                <div class="section-title">
                    <!--<span class="title-tag"><?php echo e(__('home.contact-us')); ?></span>-->
                    <h2><?php echo e(__('home.send_message')); ?></h2>
                </div>
            </div>
            <?php if(empty(Request::segment(2))): ?>
                <div class="col-lg-6 col-md-4 col-sm-5 text-end d-sm-block">
                    <a href="<?php echo e(LaravelLocalization::localizeUrl('contact-us')); ?>"
                        class="main-btn btn-filled mt-40"><?php echo e(__('home.more')); ?></a>
                </div>
                <?php endif; ?>
        </div>
             <div class="col-lg-12 col-md-12">
                 <div class="contact-info">
                     <div class="row justify-content-center">
                         <div class="col-lg-4 col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="flaticon-home"></i>
                                 </div>
                                 <div class="desc">
                                     <h4><?php echo e(__('home.address')); ?></h4>
                                     <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <p><a
                                                 href="https://www.google.com/maps/search/?api=1&query=<?php echo e(urlencode($address->{'address_' . $lang})); ?>">
                                                 <?php echo e($address->{'address_' . $lang}); ?></a> <br><br></p>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </div>
                             </div>
                         </div>
                         <div class="col-lg-4 col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="flaticon-phone"></i>
                                 </div>
                                 <div class="desc">
                                     <h4><?php echo e(__('home.number_phones')); ?></h4>
                                     <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <p><?php echo e($phone->code); ?><?php echo e($phone->phone); ?><br></p>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </div>
                             </div>
                         </div>
                         <div class="col-lg-4 col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="fas fa-envelope"></i>
                                 </div>
                                 <div class="desc">
                                     <h4><?php echo e(__('home.email')); ?></h4>
                                     <p><?php echo e($setting->email); ?></p>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
             <div class="col-lg-12 col-md-12 ">
                 <!-- Contact Form -->
                 <div class="contact-form">
                        <form action="<?php echo e(route('contact.save')); ?>" method="POST" data-toggle="validator" class="form w-100 mt-50 ajax_submit" id="ajax-contact" novalidate>
                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                            <div id="success-message" style="color: green;"></div>
                         <div class="server_response"></div>
                         <div class="row">
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="far fa-user"></i></span>
                                     <input type="text" placeholder="<?php echo e(__('home.entername')); ?>" name="name">
                                     <div class="alert alert-danger print-error-msg" id="error-name"
                                      style="display:none; color: red;"></div>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="far fa-envelope"></i></span>
                                     <input type="email" placeholder="<?php echo e(__('home.enteremail')); ?>" name="email">
                                     <div class="alert alert-danger print-error-msg" id="error-email"
                                       style="display:none; color: red;"></div>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="fas fa-phone-alt"></i></span>
                                     <input type="text" placeholder="<?php echo e(__('home.phone')); ?>" name="phone">
                                     <div class="alert alert-danger print-error-msg" id="error-phone"
                                     style="display:none; color: red;"></div>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="inputs-filed">
                                     <select name="service_id" id="guests">
                                         <option value="" disabled selected><?php echo e(__('home.Select Services Here')); ?></option>
                                         <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <?php $__currentLoopData = $service->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serchilds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <option value="<?php echo e($serchilds->id); ?>"><?php echo e($serchilds->{'name_'.$lang}); ?></option>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     </select>
                                 </div>
                             </div>
                             <div class="col-12">
                                 <div class="input-group textarea mb-30">
                                     <span class="icon"><i class="fas fa-pen"></i></span>
                                     <textarea placeholder="<?php echo e(__('home.message')); ?>" name="message" ></textarea>
                                 </div>
                             </div>
                             <div class="col-12 text-center">
                                 <button type="submit" class="main-btn btn-filled"><?php echo e(__('home.send_message')); ?></button>
                             </div>
                         </div>
                     </form>
                 </div>
             </div>
         </div>
         <div class="row">
             <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
             <?php if($index==0): ?>
                 <div class="col-lg-12 col-12 mt-4">
                     <div class="map">
                         <iframe
                             src="https://www.google.com/maps?q=<?php echo e(urlencode($address->address_en)); ?>&output=embed"
                             width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                             referrerpolicy="no-referrer-when-downgrade">
                         </iframe>
                     </div>
                 </div>
                 <?php endif; ?>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </div>
     </div>
 </section>
 <?php $__env->startSection('script'); ?>
    <script>
        $('#ajax-contact').on('submit', function(event) {
            event.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if(messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index,message){
                            const errorMessage = $("<div>").text(message);
                                errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
 <!--====== CONTACT PART END ======-->
<?php /**PATH /home/webtest/public_html/eyecare/resources/views/website/home-partials/contact.blade.php ENDPATH**/ ?>