<!--====== ROOM TYPE START ======-->
@if (!in_array(Request::segment(2), ['services', 'service']))
    <section class="image-type-section pt-115 pb-115"
        style="background-image: url({{ Helper::uploadedImagesPath('subheader', $subheader->subheader('services', 1)->image) }});">
    @else
        <section class="image-type-section pt-70 pb-115 mt-35" id="bg-none">
@endif

<div class="container">
    <div class="row align-items-center">
         @if (empty(Request::segment(2)))
        <div class="col-12">
            <div class="section-title text-center mb-50">
                <span class="title-tag">{{ __('home.our_services') }}</span>
                <h2>{{ __('home.Providing Various Services')}}</h2>
            </div>
        </div>
        @endif
        <div class="col-12">
            <ul class="room-filter nav nav-pills justify-content-center" id="room-tab" role="tablist">
                @foreach ($menuServices as $index => $service)
                    <li class="nav-item">
                        <a class="nav-link {{ $index == 0 ? 'active' : '' }}" id="service-tab-{{ $index }}"
                            data-bs-toggle="pill"
                            href="#service-{{ $index }}">{{ $service->{'name_' . $lang} }}</a>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
    <div class="tab-content mt-50" id="room-tabContent">
        @foreach ($menuServices as $index => $service)
            <div class="tab-pane fade  {{ $index == 0 ? 'show active' : '' }}" id="service-{{ $index }}"
                role="tabpanel">
                <div class="room-items">
                    <div class="row">
                        @foreach ($service->childs as $chservice)
                            <div class="col-lg-6 col-sm-6">
                                <div class="room-box">
                                    <div class="room-bg"
                                        style="background-image: url({{ Helper::uploadedImagesPath('services', $chservice->img) }});">
                                    </div>
                                    <div class="room-content">
                                        <span class="room-count"><i class="fal fa-th"></i>{{$chservice->order}}</span>
                                        <h3><a
                                                href="{{ LaravelLocalization::localizeUrl('service/' . $chservice->{'link_' . $lang}) }}">{{ $chservice->{'name_' . $lang} }}</a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @if (empty(Request::segment(2)))
                        <div class="more-btn">
                            <a href="{{ LaravelLocalization::localizeUrl('services') }}"
                                class="main-btn btn-filled mt-20">{{ __('home.more') }}</a>
                        </div>
                    @endif
                </div>
            </div>
        @endforeach
    </div>
</div>
</section>
<!--====== ROOM TYPE END ======-->
