<!--====== CONTACT PART START ======-->
 <section class="contact-part pt-115 pb-115">
     <div class="container">
         <!-- Contact Info -->
         <div class="row">
        <div class="row align-items-center mb-5">
            <div class="col-lg-6 col-md-8 col-sm-7">
                <div class="section-title">
                    <!--<span class="title-tag">{{__('home.contact-us')}}</span>-->
                    <h2>{{__('home.send_message')}}</h2>
                </div>
            </div>
            @if(empty(Request::segment(2)))
                <div class="col-lg-6 col-md-4 col-sm-5 text-end d-sm-block">
                    <a href="{{LaravelLocalization::localizeUrl('contact-us')}}"
                        class="main-btn btn-filled mt-40">{{ __('home.more') }}</a>
                </div>
                @endif
        </div>
             <div class="col-lg-12 col-md-12">
                 <div class="contact-info">
                     <div class="row justify-content-center">
                         <div class="col-lg-4 col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="flaticon-home"></i>
                                 </div>
                                 <div class="desc">
                                     <h4>{{ __('home.address') }}</h4>
                                     @foreach ($addresses as $address)
                                         <p><a
                                                 href="https://www.google.com/maps/search/?api=1&query={{ urlencode($address->{'address_' . $lang}) }}">
                                                 {{ $address->{'address_' . $lang} }}</a> <br><br></p>
                                     @endforeach
                                 </div>
                             </div>
                         </div>
                         <div class="col-lg-4 col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="flaticon-phone"></i>
                                 </div>
                                 <div class="desc">
                                     <h4>{{ __('home.number_phones') }}</h4>
                                     @foreach ($phones as $phone)
                                         <p>{{ $phone->code }}{{ $phone->phone }}<br></p>
                                     @endforeach
                                 </div>
                             </div>
                         </div>
                         <div class="col-lg-4 col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="fas fa-envelope"></i>
                                 </div>
                                 <div class="desc">
                                     <h4>{{ __('home.email') }}</h4>
                                     <p>{{ $setting->email }}</p>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
             <div class="col-lg-12 col-md-12 ">
                 <!-- Contact Form -->
                 <div class="contact-form">
                        <form action="{{ route('contact.save') }}" method="POST" data-toggle="validator" class="form w-100 mt-50 ajax_submit" id="ajax-contact" novalidate>
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <div id="success-message" style="color: green;"></div>
                         <div class="server_response"></div>
                         <div class="row">
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="far fa-user"></i></span>
                                     <input type="text" placeholder="{{__('home.entername')}}" name="name">
                                     <div class="alert alert-danger print-error-msg" id="error-name"
                                      style="display:none; color: red;"></div>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="far fa-envelope"></i></span>
                                     <input type="email" placeholder="{{__('home.enteremail')}}" name="email">
                                     <div class="alert alert-danger print-error-msg" id="error-email"
                                       style="display:none; color: red;"></div>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="fas fa-phone-alt"></i></span>
                                     <input type="text" placeholder="{{__('home.phone')}}" name="phone">
                                     <div class="alert alert-danger print-error-msg" id="error-phone"
                                     style="display:none; color: red;"></div>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="inputs-filed">
                                     <select name="service_id" id="guests">
                                         <option value="" disabled selected>{{__('home.Select Services Here')}}</option>
                                         @foreach ($services as $service)
                                          @foreach($service->childs as $serchilds)
                                         <option value="{{$serchilds->id }}">{{$serchilds->{'name_'.$lang} }}</option>
                                         @endforeach
                                         @endforeach
                                     </select>
                                 </div>
                             </div>
                             <div class="col-12">
                                 <div class="input-group textarea mb-30">
                                     <span class="icon"><i class="fas fa-pen"></i></span>
                                     <textarea placeholder="{{__('home.message')}}" name="message" ></textarea>
                                 </div>
                             </div>
                             <div class="col-12 text-center">
                                 <button type="submit" class="main-btn btn-filled">{{__('home.send_message')}}</button>
                             </div>
                         </div>
                     </form>
                 </div>
             </div>
         </div>
         <div class="row">
             @foreach ($addresses as $index=>$address)
             @if($index==0)
                 <div class="col-lg-12 col-12 mt-4">
                     <div class="map">
                         <iframe
                             src="https://www.google.com/maps?q={{ urlencode($address->address_en) }}&output=embed"
                             width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                             referrerpolicy="no-referrer-when-downgrade">
                         </iframe>
                     </div>
                 </div>
                 @endif
             @endforeach
         </div>
     </div>
 </section>
 @section('script')
    <script>
        $('#ajax-contact').on('submit', function(event) {
            event.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if(messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index,message){
                            const errorMessage = $("<div>").text(message);
                                errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
@endsection
 <!--====== CONTACT PART END ======-->
