<?php if(count($blogs) > 0): ?>
    <!-- <================================================================= Blogs Area =======================================================> -->
    <section class="blog-area pt-100 pb-70">
        <div class="container">
            <?php if(Request::segment(2) != 'blogs'): ?>
                <div class="section-title-two">
                    <span><?php echo e(trans('home.blogs')); ?></span>
                    <h2><?php echo e($configration->app_name); ?></h2>
                </div>
            <?php endif; ?>
            <div class="row justify-content-center">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-6 col-lg-4 wow fadeInUp" data-wow-delay=".3s">
                        <div class="blog-item">
                            <div class="blog-top">
                                <a href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $blog->{'link_' . $lang})); ?>">
                                    <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $blog->image)); ?>" alt="Blog">
                                </a>
                            </div>
                            <div class="blog-bottom">
                                <h3>
                                    <a
                                        href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $blog->{'link_' . $lang})); ?>"><?php echo e($blog->{'title_' . $lang}); ?></a>
                                </h3>
                                <?php echo Str::limit($blog->{'text_' . $lang}, 100); ?>

                                <ul>
                                    <li>
                                        <a
                                            href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $blog->{'link_' . $lang})); ?>">
                                            <?php echo e(trans('home.more')); ?>

                                            <i class="icofont-long-arrow-right"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php if(Request::segment(2) != 'blogs'): ?>
                <div class="text-center">
                    <a href="<?php echo e(LaravelLocalization::localizeUrl('blogs')); ?>" class="main-btn">
                        <?php echo e(trans('home.allblogs')); ?>

                        <span class="icofont-arrow-right"></span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <!-- <================================================================= Blogs Area =======================================================> -->
<?php endif; ?>
<?php /**PATH C:\OSPanel\domains\drshrief\resources\views/website/home-partials/blogs.blade.php ENDPATH**/ ?>