<title><?php echo e(trans('home.add_writer')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.writers')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/writers')); ?>"><?php echo e(trans('home.writers')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_writer')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.add_writer')); ?></h6>
                        </div>
                        <?php echo Form::open(['route' => 'writers.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label for="name"><?php echo e(trans('home.name')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name')); ?>" name="name" required>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="email"><?php echo e(trans('home.email')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.email')); ?>" name="email">
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="phone"><?php echo e(trans('home.phone')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.phone')); ?>" name="phone">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="position"><?php echo e(trans('home.position')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.position')); ?>" name="position">
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="facebook"><?php echo e(trans('home.facebook')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.facebook')); ?>" name="facebook">
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="linkedin"><?php echo e(trans('home.linkedin')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.linkedin')); ?>" name="linkedin">
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="instgram"><?php echo e(trans('home.instgram')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.instgram')); ?>" name="instgram">
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="twitter"><?php echo e(trans('home.twitter')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.twitter')); ?>" name="twitter">
                                </div>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-9 ">    
                                    <fieldset class="form-group">
                                        <label for="aboutWriter"><?php echo e(trans('home.aboutWriter')); ?></label>
                                        <textarea class="form-control area1" placeholder="<?php echo e(trans('home.aboutWriter')); ?>" name="aboutWriter"></textarea>
                                    </fieldset>
                                </div>
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>


                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/writers')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/calibra/resources/views/admin/writers/addWriter.blade.php ENDPATH**/ ?>