<title><?php echo e(trans('home.contactUsMessages')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.contactUsMessages')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.contactUsMessages')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.contactUsMessages')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th><?php echo e(trans('home.name')); ?></th>
                                    <th><?php echo e(trans('home.email')); ?></th>
                                    <th><?php echo e(trans('home.phone')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $contactUsMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contactUsMessage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($contactUsMessage->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($contactUsMessage->id); ?>" /> </td>
                                        <td><a href="<?php echo e(route('contact-us-messages.edit', $contactUsMessage->id)); ?>"><?php echo e($contactUsMessage->id); ?></a></td>
                                        <td><a href="<?php echo e(route('contact-us-messages.edit', $contactUsMessage->id)); ?>"><?php echo e($contactUsMessage->name); ?></a></td>
                                        <td><a href="<?php echo e(route('contact-us-messages.edit', $contactUsMessage->id)); ?>"><?php echo e($contactUsMessage->email); ?></a></td>
                                        <td><a href="<?php echo e(route('contact-us-messages.edit', $contactUsMessage->id)); ?>"><?php echo e($contactUsMessage->phone); ?></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/admin/contactUsMessages/contactUsMessages.blade.php ENDPATH**/ ?>